<?php
include '../ConsumoApi/Conexion.php';
header("Content-Type: application/json; charset=UTF-8");

class Operaciones
{
	public function PA_ListarPersonal_ParaAsistencia($ASIST_Cod, $personal, $OB_Codigo)
	{
	    $conn = new Conexion();
        $conn->Conectar();
        $conn->Parametro("@ASIST_Cod", $ASIST_Cod);
        $conn->Parametro("@area", "");
        $conn->Parametro("@cargo", "");
        $conn->Parametro("@personal", $personal);
        $conn->Parametro("@obra", $OB_Codigo);
        $conn->Parametro("@obra", 7);
        $data = $conn->Procedimiento("dbo.PA_ListarPersonal_ParaAsistencia");
        $conn->Desconectar();
        return json_encode($data);
	}
	
	public function modificarListaAsistencia($listaAsistencia){
	    $conn = new Conexion();
        $conn->Conectar();
        
        $data = [];
        for($i=0; $i<count($listaAsistencia); $i++){
            $dd = $listaAsistencia[$i];
            $conn->reiniciarArray();
            $conn->Parametro("@codigo", $dd['codigo']);
            $conn->Parametro("@horaEntradaTurnoDia", $dd['horaEntradaTurnoDia']);
            $conn->Parametro("@horaSalidaTurnoDia", $dd['horaSalidaTurnoDia']);
            $conn->Parametro("@horaEntradaTurnoTarde", $dd['horaEntradaTurnoTarde']);
            $conn->Parametro("@horaSalidaTurnoTarde", $dd['horaSalidaTurnoTarde']);
            $conn->Parametro("@obsTurnoTarde", $dd['obsTurnoTarde']);
            $conn->Parametro("@detConcepto", $dd['detConcepto']);
            $conn->Parametro("@diaTrabajado", $dd['diaTrabajado']);
            $conn->Parametro("@horaExtra", $dd['horaExtra']);
            $conn->Parametro("@minutoExtra25", $dd['minutoExtra25']);
            $conn->Parametro("@horaExtra35", $dd['horaExtra35']);
            $conn->Parametro("@minutoExtra35", $dd['minutoExtra35']);
            $conn->Parametro("@tipoHoraExtra", $dd['tipoHoraExtra']);
            $conn->Parametro("@domingoTrabajado", $dd['domingoTrabajado']);
            $conn->Parametro("@obsPalabraClave", $dd['obsPalabraClave']);
            $conn->Parametro("@feriadoLaborado", $dd['feriadoLaborado']);
            $conn->Parametro("@maternidad", $dd['maternidad']);
            $conn->Parametro("@incapacidad", $dd['incapacidad']);
            $conn->Parametro("@sancion", $dd['sancion']);
            $conn->Parametro("@licencia", $dd['licencia']);
            $conn->Parametro("@falta", $dd['falta']);
            $conn->Parametro("@enfermedad", $dd['enfermedad']);
            $conn->Parametro("@descanso", $dd['descanso']);
            $conn->Parametro("@turno", $dd['turno']);
            $conn->Parametro("@emp_id", $dd['emp_id']);
            $conn->Parametro("@CodAsistencia", $dd['CodAsistencia']);
            $conn->Parametro("@FECHA", $dd['FECHA']);
            $conn->Parametro("@OB_Codigo", $dd['OB_Codigo']);
            $conn->Parametro("@CON_DiasMesLaborable", $dd['CON_DiasMesLaborable']);
            $conn->Parametro("@CON_DiasQuincenaLaborable", $dd['CON_DiasQuincenaLaborable']);
            $conn->Parametro("@CON_DiasSemanaLaborable", $dd['CON_DiasSemanaLaborable']);
            $conn->Parametro("@CON_HorasDiaLaborable", $dd['CON_HorasDiaLaborable']);
            $conn->Parametro("@CON_PesoDia", $dd['CON_PesoDia']);
            $conn->Parametro("@CON_PesoFeriados", $dd['CON_PesoFeriados']);
            $conn->Parametro("@ASIST_DIA_AsistioDia", $dd['ASIST_DIA_AsistioDia']);
            $conn->Parametro("@ASIST_DIA_AsistioTarde", $dd['ASIST_DIA_AsistioTarde']);
            $data = $conn->Procedimiento("dbo.PA_CrearAsistenciaSemanal");   
        }
        
        $conn->Desconectar();
        $data = ['rpta'=>'ok'];
        return json_encode($data);
	}
}

$request = json_decode(file_get_contents('php://input'), true);

switch ($request['accion']) {
    case 'PA_ListarPersonal_ParaAsistencia':
		try{
		    $ASIST_Cod = $request['ASIST_Cod'];
		    $personal = $request['personal'];
		    $OB_Codigo = $request['OB_Codigo'];
        	$app = new Operaciones();
        	echo $app->PA_ListarPersonal_ParaAsistencia($ASIST_Cod, $personal, $OB_Codigo);
	    }catch (Exception $ex){
	        $data = [];
	        array_push($data, $ex);
	        echo json_encode($data);
	    }
	    break;
	    
	case 'modificarListaAsistencia':
	    try{
		    $listaAsistencia = $request['listaAsistencia'];
        	$app = new Operaciones();
        	echo $app->modificarListaAsistencia($listaAsistencia);
	    }catch (Exception $ex){
	        $data = ['rpta'=>'Error: '.$ex];
	        echo json_encode($data);
	    }
	    break;
	    
}



