<?php

namespace App;

use JsonSerializable;

class ArrayList implements JsonSerializable
{
    private $i;
    private $size;
    private $list = array();

    public function __construct(){
        $args = func_get_args();
        $nargs = func_num_args();
        switch ($nargs) {
            case 0:
                self::__construct0();
                break;
            case 1:
                self::__construct1($args[0]);
                break;
        }
    }

    public function __construct0(){
        $this->i = 0;
        $this->size = 0;
    }

    public function __construct1($array){
        $this->i = count($array);
        $this->size = $this->i;
        $this->list = $array;
    }

    public function getSize(){
        return $this->size;
    }

    public function addElement($element){
        $this->list[$this->i] = $element;
        $this->i++;
        $this->size = $this->i; /*<- tamaño del array despues de insertar un elemento*/
    }

    public function removeElement($index){
        $listAux = array();
        $k = 0;
        for($j=0; $j<$this->size; $j++){
            if($j != $index){
                $listAux[$k] = self::getElement($j);
                $k++;
            }
        }
        $this->list = $listAux;
        $this->size--;
        $this->i--;
    }

    public function getElement($index){
        return $this->list[$index];
    }

    public function toString(){
        $infoList = "Content: {";
        if($this->list != null){
            for($i=0; $i<$this->size; $i++)
                $infoList = $infoList . $this->list[$i]->toString();
        }
        else
            $infoList = $infoList . " List is Empy! ";
        return $infoList . "}";
    }

    public function isEmpty(){
        if($this->size == 0)
            return true;
        else
            return false;
    }

    public function getList(){
        return $this->list;
    }

    /**
     * (PHP 5 &gt;= 5.4.0)<br/>
     * Specify data which should be serialized to JSON
     * @link http://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     */
    function jsonSerialize()
    {
        $objets = array();
        if($this->list != null){
            for($i=0; $i<$this->size; $i++)
                array_push($objets, $this->list[$i]->jsonSerialize());
        }
        else
            array_push($objets, "List is Empy!");
        return json_encode($objets);
    }
}
