<?php

namespace App\Http\Controllers;

use App\ArrayList;
use App\Models\Caja;
use App\Traits\Conexion;
use App\Traits\util;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Carbon\Carbon;

class CajaController extends Controller
{    
    use util;
    public function ListarCajaVer($sucursal)
    {              
        $body = [
            'accion' => 'PA_ListarCajaVer',   
            'sucursal' => 'PRINCIPAL',
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarPermisosWeb_PorUsuario($codigo){
        $body = [
            'accion' => 'PA_ListarPermisosWeb_PorUsuario',
            'Codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_EstadoCaja_xCodigo_WEB($CD_Codigo)
    {              
        $body = [
            'accion' => 'PA_EstadoCaja_xCodigo_WEB',   
            'CD_Codigo' => $CD_Codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarIngresosDineroEntreFechasXCaja($Inicio, $Final, $Codigo)
    {              
        $body = [
            'accion' => 'PA_ListarIngresosDineroEntreFechasXCaja',   
            'FechaInicio' => $Inicio,
            'FechaFinal' => $Final,
            'Codigo' => $Codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarSalidasDineroEntreFechasxCaja($Inicio, $Final, $Codigo)
    {              
        $body = [
            'accion' => 'PA_ListarSalidasDineroEntreFechasxCaja',   
            'FechaInicio' => $Inicio,
            'FechaFinal' => $Final,
            'Codigo' => $Codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarVentas_WEB($Inicio, $Final)
    {              
        $body = [
            'accion' => 'PA_ListarVentas_WEB',   
            'FechaInicio' => $Inicio,
            'FechaFinal' => $Final,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarArticulos_PorTipo($Tipo, $Descripcion, $Categoria)
    {              
        $body = [
            'accion' => 'PA_ListarArticulos_PorTipo',   
            'Tipo' => $Tipo,
            'Descripcion' => $Descripcion,
            'Categoria' => $Categoria,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarInsumos_WEB($descripcion, $cat, $tip)
    {              
        $body = [
            'accion' => 'PA_ListarInsumos_WEB',   
            'descrip' => $descripcion,
            'cat' => $cat,
            'tipo' => $tip,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarCategorias_PorTipoWEB($Tipo)
    {              
        $body = [
            'accion' => 'PA_ListarCategorias_PorTipoWEB',   
            'Tipo' => $Tipo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarBebidasStockMinimo()
    {              
        $body = [
            'accion' => 'PA_ListarBebidasStockMinimo',   
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarInsumosStockMinimo()
    {              
        $body = [
            'accion' => 'PA_ListarInsumosStockMinimo',   
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarCajasxFecha(Request $request){
        
        $desde = date('d/m/Y');
        $hasta = date('d/m/Y');
        
        $fInicio = date('Ymd');
        $fFinal = date('Ymd');
        
        if ($request->get('inicio') != null && $request->get('final') != null){
            $desde = $request->get('inicio');
            $hasta = $request->get('final');
            
            $data = explode('/', $desde);
            $fInicio = $data[2] . '' . $data[1] . '' . $data[0];
            $data = explode('/', $hasta);
            $fFinal = $data[2] . '' . $data[1] . '' . $data[0];
        }
        
        $body = [
            'accion' => 'PA_ListarCajasxFecha',   
            'fechaInicio' => $fInicio,   
            'fechaFinal' => $fFinal,   
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $array = $datos->json();
        
        $nuevoArray = array();
        foreach($array as $item){
            $Cod = $item['CD_Codigo'];
            $Ini = \Carbon\Carbon::parse($item['CD_Inicio'])->format('d/m/Y h:i a');
            $Fin = '-';
            if ($item['CD_Estado'] == "Cerrado"){
                $Fin = \Carbon\Carbon::parse($item['CD_Final'])->format('d/m/Y h:i a');
            }
            $Est = $item['CD_Estado'];
            
            $fila = [
                'CD_Codigo' => $Cod,
                'CD_Inicio' => $Ini,
                'CD_Final' => $Fin,
                'CD_Estado' => $Est,
            ];
            array_push($nuevoArray, $fila);
        }
        
        return $nuevoArray;
    }
    
    public function VerCaja(Request $request)
    {
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        session(['pos' => '2', 'subitem' => '2.1']);
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        if ($user['VerCaja'] != "SI"){
            return redirect()->route('Pedido.index')->with('error', 'NO TIENE PERMISO PARA CONTINUAR.');
        }
        
        $cd_codigo = '';
        if ($request->get('cd') != null){
            $cd_codigo=$request->get('cd');
        }
        $datos = (new CajaController())->PA_EstadoCaja_xCodigo_WEB($cd_codigo);

        $saldoinicial = 0;
        $ingresos = 0;
        $ventas = 0;
        $egresos = 0;
        $yape = 0;
        $tarjeta = 0;
        $plim = 0;
        $transferencia = 0;
        $totalCaja = 0;
        $descripCaja = '';
        
        foreach($datos as $row){
            $saldoinicial = $row['SALDO_INICIAL'];
            $ingresos = $row['INGRESOS'];
            $ventas = $row['VENTAS'];
            $egresos = $row['EGRESOS'];
            $yape = $row['YAPE'];
            $tarjeta = $row['TARJETA'];
            $plim = $row['PLIM'];
            $transferencia = $row['TRANSFERENCIA'];
            $totalCaja = $row['SOLOEFECTIVO'];
            $descripCaja = 'Caja Nº: '.$row['CD_Codigo'].' con estado: '.strtoupper($row['CD_Estado']);
        }
        
        $caja = [
            'saldoinicial'=>$saldoinicial,
            'ingresos'=>$ingresos,
            'ventas'=>$ventas,
            'egresos'=>$egresos,
            'yape'=>$yape,
            'tarjeta'=>$tarjeta,
            'plim'=>$plim,
            'transferencia'=>$transferencia,
            'totalCaja'=>$totalCaja,
            'descripCaja'=>$descripCaja,
            ];
        
        return view('Caja.VerCaja', compact('user', 'caja'));
    }
    
    public function VerIngresos(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        session(['pos' => '3', 'subitem' => '3.1']);
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);

        $buscar_cliente = 0;

        $desde = $request->desde;
        $hasta = $request->hasta;
        $idcliente = $request->idcliente;
        if ($desde != null && $hasta != null) {
            session(['VentasGenerales_desdeING' => $desde]);
            session(['VentasGenerales_hastaING' => $hasta]);
        }
        $desde = session('VentasGenerales_desdeING');
        $hasta = session('VentasGenerales_hastaING');

        $ndesde = '';
        $nhasta = '';

        if ($desde != null && $hasta != null) {
            $data = explode('/', $desde);
            $ndesde = $data[2] . '' . $data[1] . '' . $data[0];
            $data = explode('/', $hasta);
            $nhasta = $data[2] . '' . $data[1] . '' . $data[0];

            if ($idcliente != null) {
                session(['VentasGenerales_idclienteING' => $idcliente]);
            }
            $idcliente = session('VentasGenerales_idclienteING');
            if ($idcliente != null && $idcliente != 0) {
                $buscar_cliente = $idcliente;
            }
        } else {
            $desde = date('d/m/Y');
            $hasta = date('d/m/Y');
            $ndesde = date('Ymd');
            $nhasta = date('Ymd');
        }
  
        $contado = 0;
        $credito = 0;
        $total = 0;
        
        $cliente = null;
        //Buscar datos de la web
        
        $body = [
            'accion' => 'PA_ListarIngresos',
            'Inicial' => $ndesde,
            'Final' => $nhasta,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);                
        $datos = $datos->json();
        
        $ventas = array();
        foreach($datos as $item){
            
            $total += $item['ID_Total'];
            
            $fila = [
                'ID_Codigo' => $item['ID_Codigo'],
                'ID_FechaIngreso' => Carbon::parse($item['ID_FechaIngreso'])->format('d-m-Y h:i a'),
                'ID_Nro' => $item['ID_Nro'],
                'ID_Concepto' => $item['ID_Concepto'],
                'TO_Descripcion' => $item['TO_Descripcion'],
                'ID_Total' => $item['ID_Total']
            ];
            array_push($ventas, $fila);
        }
         return 0;
        return view('Caja.Ingresos', compact('user', 'desde', 'hasta', 'cliente', 'ventas', 'contado', 'credito', 'total'));
    }
    
    public function VerEgresos(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        session(['pos' => '3', 'subitem' => '3.3']);
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);

        $buscar_cliente = 0;

        $desde = $request->desde;
        $hasta = $request->hasta;
        $idcliente = $request->idcliente;
        if ($desde != null && $hasta != null) {
            session(['VentasGenerales_desdeSAL' => $desde]);
            session(['VentasGenerales_hastaSAL' => $hasta]);
        }
        $desde = session('VentasGenerales_desdeSAL');
        $hasta = session('VentasGenerales_hastaSAL');

        $ndesde = '';
        $nhasta = '';

        if ($desde != null && $hasta != null) {
            $data = explode('/', $desde);
            $ndesde = $data[2] . '' . $data[1] . '' . $data[0];
            $data = explode('/', $hasta);
            $nhasta = $data[2] . '' . $data[1] . '' . $data[0];

            if ($idcliente != null) {
                session(['VentasGenerales_idclienteSAL' => $idcliente]);
            }
            $idcliente = session('VentasGenerales_idclienteSAL');
            if ($idcliente != null && $idcliente != 0) {
                $buscar_cliente = $idcliente;
            }
        } else {
            $desde = date('d/m/Y');
            $hasta = date('d/m/Y');
            $ndesde = date('Ymd');
            $nhasta = date('Ymd');
        }
  
        $contado = 0;
        $credito = 0;
        $total = 0;
        
        $cliente = null;
        //Buscar datos de la web
        
        $body = [
            'accion' => 'PA_ListarEgresos',
            'Inicial' => $ndesde,
            'Final' => $nhasta,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);                
        $datos = $datos->json();
        
        $ventas = array();
        foreach($datos as $item){
            
            $total += $item['SAL_Total'];
            
            $fila = [
                'SAL_Codigo' => $item['SAL_Codigo'],
                'SAL_FechaSalida' => Carbon::parse($item['SAL_FechaSalida'])->format('d-m-Y h:i a'),
                'SAL_Nro' => $item['SAL_Nro'],
                'TO_Descripcion' => $item['TO_Descripcion'],
                'SAL_Concepto' => $item['SAL_Concepto'],
                'SAL_Total' => $item['SAL_Total']
            ];
            array_push($ventas, $fila);
        }
        
        return view('Caja.Egresos', compact('user', 'desde', 'hasta', 'cliente', 'ventas', 'contado', 'credito', 'total'));
    }
    
    public function VerVentas(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        session(['pos' => '3', 'subitem' => '3.1']);
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        if ($user['ListarVentas'] != "SI"){
            return redirect()->route('Pedido.index')->with('error', 'NO TIENE PERMISO PARA CONTINUAR.');
        } 
        
        $desde = date('d/m/Y');
        $hasta = date('d/m/Y');
        
        $fInicio = date('Ymd');
        $fFinal = date('Ymd');
        
        if ($request->get('desde') != null && $request->get('hasta') != null){
            $desde = $request->get('desde');
            $hasta = $request->get('hasta');
            
            $data = explode('/', $desde);
            $fInicio = $data[2] . '' . $data[1] . '' . $data[0];
            $data = explode('/', $hasta);
            $fFinal = $data[2] . '' . $data[1] . '' . $data[0];
        }
        
        $datos = (new CajaController())->PA_ListarVentas_WEB($fInicio, $fFinal);
        
        $descripCaja = 'VENTAS POR FECHAS';
        return view('Ventas.CatalogoVentas', compact('user', 'descripCaja', 'desde', 'hasta', 'datos'));
    }
    
    public function VerComidas(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        session(['pos' => '2', 'subitem' => '2.1']);
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        $buscarpor = $request->buscarpor;
        if ($buscarpor == null) $buscarpor = '';
        
        $body = [
            'accion' => 'PA_ListarProductos_PorDescripcion',
            'buscar1' => $buscarpor,
            'buscar2' => '',
            'buscar3' => '',
            'buscar4' => '',
            'buscar5' => '',
            'buscar6' => ''
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);                
        $articulos = $datos->json();
        
        return view('Almacen.VerComidas', compact('user', 'buscarpor', 'articulos'));
    }
    
    public function VerBebidas(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        session(['pos' => '4', 'subitem' => '4.2']);
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        if ($user['VerBebidas'] != "SI"){
            return redirect()->route('Pedido.index')->with('error', 'NO TIENE PERMISO PARA CONTINUAR.');
        }  
        
        $tipo = '';
        
        $nom = '';
        if ($request->get('nom') != null){
            $nom = $request->get('nom');
        }
        
        $cat = '';
        if ($request->get('cat') != null){
            $cat = $request->get('cat');
            $tipo = 'BEBIDA-CAT';
        }
        else{
            $tipo = 'BEBIDA';
        }
        
        $datos = (new CajaController())->PA_ListarArticulos_PorTipo($tipo, $nom, $cat);
        $categorias = (new CajaController())->PA_ListarCategorias_PorTipoWEB('BEBIDAS');
        $descripCaja = 'CATÁLOGO DE BEBIDAS';
        return view('Almacen.VerBebidas', compact('user', 'datos', 'descripCaja', 'nom', 'categorias', 'cat'));
    }
    
    public function VerInsumos(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        session(['pos' => '4', 'subitem' => '4.3']);
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        if ($user['VerInsumos'] != "SI"){
            return redirect()->route('Pedido.index')->with('error', 'NO TIENE PERMISO PARA CONTINUAR.');
        }    
        
        
        $tipo = 0;
        
        $nom = '';
        if ($request->get('nom') != null){
            $nom = $request->get('nom');
        }
        
        $cat = '';
        if ($request->get('cat') != null){
            $cat = $request->get('cat');
            $tipo = 1;
        }
        
        $datos = (new CajaController())->PA_ListarInsumos_WEB($nom, $cat, $tipo);
        $categorias = (new CajaController())->PA_ListarCategorias_PorTipoWEB('INSUMOS');
        $descripCaja = 'CATÁLOGO DE INSUMOS';
        return view('Almacen.VerInsumos', compact('user', 'datos', 'descripCaja', 'nom', 'categorias', 'cat'));
    }
    
    public function IndexReportes(){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        session(['pos' => '5', 'subitem' => '5.1']);
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        if ($user['VerReportes'] != "SI"){
            return redirect()->route('Pedido.index')->with('error', 'NO TIENE PERMISO PARA CONTINUAR.');
        }  
        
        return view('Reportes.index', compact('user'));
    }
    
    public function VerStockMinBebidas(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        $tipo = '';
        
        $nom = '';
        if ($request->get('nom') != null){
            $nom = $request->get('nom');
        }
        
        $cat = '';
        if ($request->get('cat') != null){
            $cat = $request->get('cat');
            $tipo = 'BEBIDA-CAT';
        }
        else{
            $tipo = 'BEBIDA';
        }
        
        $datos = (new CajaController())->PA_ListarBebidasStockMinimo($tipo, $nom, $cat);
        $descripCaja = 'ST. MÍNIMO DE BEBIDAS';
        return view('Reportes.StBebidas', compact('user', 'datos', 'descripCaja', 'nom', 'cat'));
    }
    
    public function VerStockMinInsumos(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        $tipo = '';
        
        $nom = '';
        if ($request->get('nom') != null){
            $nom = $request->get('nom');
        }
        
        $cat = '';
        if ($request->get('cat') != null){
            $cat = $request->get('cat');
            $tipo = 'BEBIDA-CAT';
        }
        else{
            $tipo = 'BEBIDA';
        }
        
        $datos = (new CajaController())->PA_ListarInsumosStockMinimo($tipo, $nom, $cat);
        $descripCaja = 'ST. MÍNIMO DE INSUMOS';
        return view('Reportes.StInsumos', compact('user', 'datos', 'descripCaja', 'nom', 'cat'));
    }
    
    //---------------------- REPORTES --------------------------
    //----------------------------------------------------------
    
    public function PA_ListarComidas_ConReceta($descripcion)
    {              
        $body = [
            'accion' => 'PA_ListarComidas_ConReceta',   
            'Descripcion' => $descripcion,   
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ReporteComidas_PorFechas($inicio, $final, $cat, $panel, $tipo)
    {              
        $body = [
            'accion' => 'PA_ReporteComidas_PorFechas',   
            'Inicio' => $inicio,   
            'Fin' => $final,   
            'Cat' => $cat,   
            'Panel' => $panel,   
            'Tipo' => $tipo,   
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ReporteInsumos_AlaFecha($inicio1, $inicio2, $inicio3, $inicio4, $inicio5, $inicio6, $inicio7, $final, $cat, $panel, $nom, $tipo)
    {              
        $body = [
            'accion' => 'PA_ReporteInsumos_AlaFecha',   
            'Inicio1' => $inicio1, 
            'Inicio2' => $inicio2, 
            'Inicio3' => $inicio3, 
            'Inicio4' => $inicio4, 
            'Inicio5' => $inicio5, 
            'Inicio6' => $inicio6, 
            'Inicio7' => $inicio7, 
            'Fin' => $final,   
            'Cat' => $cat,   
            'Panel' => $panel,   
            'Nombre' => $nom,
            'Tipo' => $tipo,   
        ];
        
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function ReporteVentasComidas(Request $request){
        
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        $desde = date('d/m/Y');
        $hasta = date('d/m/Y');
        $fInicio = date('Ymd');
        $fFinal = date('Ymd');
        $cat = '';
        
        $tipo = 0;
        
        if ($request->get('desde') != null && $request->get('hasta') != null){
            $desde = $request->get('desde');
            $hasta = $request->get('hasta');
            
            $data = explode('/', $desde);
            $fInicio = $data[2] . '' . $data[1] . '' . $data[0];
            $data = explode('/', $hasta);
            $fFinal = $data[2] . '' . $data[1] . '' . $data[0];
        }
        
        $cat = '';
        if ($request->get('cat') != null){
            if ($request->get('cat') != "TODOS"){
                $cat = $request->get('cat');   
                $tipo = 1;
            }
        }
        
        $panel = 'COMIDAS';
        
        $datos = (new CajaController())->PA_ReporteComidas_PorFechas($fInicio, $fFinal, $cat, $panel, $tipo);
        $categorias = (new CajaController())->PA_ListarCategorias_PorTipoWEB('COMIDAS');
        $descripCaja = 'REPORTE DE VENTAS DE COMIDAS';
        
        return view('Reportes.RptComidas', compact('user', 'datos', 'descripCaja', 'categorias', 'cat', 'desde', 'hasta'));
    }
    
    public function ReporteVentasBebidas(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        $desde = date('d/m/Y');
        $hasta = date('d/m/Y');
        $fInicio = date('Ymd');
        $fFinal = date('Ymd');
        $cat = '';
        
        $tipo = 0;
        
        if ($request->get('desde') != null && $request->get('hasta') != null){
            $desde = $request->get('desde');
            $hasta = $request->get('hasta');
            
            $data = explode('/', $desde);
            $fInicio = $data[2] . '' . $data[1] . '' . $data[0];
            $data = explode('/', $hasta);
            $fFinal = $data[2] . '' . $data[1] . '' . $data[0];
        }
        
        $cat = '';
        if ($request->get('cat') != null){
            if ($request->get('cat') != "TODOS"){
                $cat = $request->get('cat');   
                $tipo = 1;
            }
        }
        
        $panel = 'BEBIDAS';
        
        $datos = (new CajaController())->PA_ReporteComidas_PorFechas($fInicio, $fFinal, $cat, $panel, $tipo);
        $categorias = (new CajaController())->PA_ListarCategorias_PorTipoWEB('BEBIDAS');
        $descripCaja = 'REPORTE DE VENTAS DE BEBIDAS';
        
        return view('Reportes.RptBebidas', compact('user', 'datos', 'descripCaja', 'categorias', 'cat', 'desde', 'hasta'));
    }
    
    public function ReporteVentasHelados(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        
        $desde = date('d/m/Y');
        $hasta = date('d/m/Y');
        $fInicio = date('Ymd');
        $fFinal = date('Ymd');
        $cat = '';
        
        $tipo = 0;
        
        if ($request->get('desde') != null && $request->get('hasta') != null){
            $desde = $request->get('desde');
            $hasta = $request->get('hasta');
            
            $data = explode('/', $desde);
            $fInicio = $data[2] . '' . $data[1] . '' . $data[0];
            $data = explode('/', $hasta);
            $fFinal = $data[2] . '' . $data[1] . '' . $data[0];
        }
        
        $cat = '';
        if ($request->get('cat') != null){
            if ($request->get('cat') != "TODOS"){
                $cat = $request->get('cat');   
                $tipo = 1;
            }
        }
        
        $panel = 'HELADOS';
        
        $datos = (new CajaController())->PA_ReporteComidas_PorFechas($fInicio, $fFinal, $cat, $panel, $tipo);
        $categorias = (new CajaController())->PA_ListarCategorias_PorTipoWEB('HELADOS');
        $descripCaja = 'REPORTE DE VENTAS DE HELADOS';
        
        return view('Reportes.RptHelados', compact('user', 'datos', 'descripCaja', 'categorias', 'cat', 'desde', 'hasta'));
    }
    
    public function ReporteVentasOtros(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal); 
        
        $desde = date('d/m/Y');
        $hasta = date('d/m/Y');
        $fInicio = date('Ymd');
        $fFinal = date('Ymd');
        $cat = '';
        
        $tipo = 0;
        
        if ($request->get('desde') != null && $request->get('hasta') != null){
            $desde = $request->get('desde');
            $hasta = $request->get('hasta');
            
            $data = explode('/', $desde);
            $fInicio = $data[2] . '' . $data[1] . '' . $data[0];
            $data = explode('/', $hasta);
            $fFinal = $data[2] . '' . $data[1] . '' . $data[0];
        }
        
        $cat = '';
        if ($request->get('cat') != null){
            if ($request->get('cat') != "TODOS"){
                $cat = $request->get('cat');   
                $tipo = 1;
            }
        }
        
        $panel = 'OTROS';
        
        $datos = (new CajaController())->PA_ReporteComidas_PorFechas($fInicio, $fFinal, $cat, $panel, $tipo);
        $categorias = (new CajaController())->PA_ListarCategorias_PorTipoWEB('OTROS');
        $descripCaja = 'REPORTE DE VENTAS DE OTROS';
        
        return view('Reportes.RptOtros', compact('user', 'datos', 'descripCaja', 'categorias', 'cat', 'desde', 'hasta'));
    }
    
    public function ReporteAlaFechaInsumos(Request $request){
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }         
        
        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);   
        
        $hasta = date('d/m/Y');
        $fFinal = date('Ymd');
        $cat = '';
        
        $tipo = 0;
        
        if ($request->get('hasta') != null){
            $hasta = $request->get('hasta');
            
            $data = explode('/', $hasta);
            $fFinal = $data[2] . '' . $data[1] . '' . $data[0];
        }
        
        $cat = '';
        if ($request->get('cat') != null){
            if ($request->get('cat') != "TODOS"){
                $cat = $request->get('cat');   
                $tipo = 1;
            }
        }
        
        $panel = 'INSUMOS';
        
        if ($hasta != date('d/m/Y')){
            $fFinal = $fFinal.' 23:59:59';
        }
        else{
            $fFinal = $fFinal.' '.date('H:i:s');
        }
        
        //strtotime($fecha_actual."- 1 days")); 
        
        $mes1 = date('m', strtotime($fFinal."- 6 days"));
        $mes7 = date('m', strtotime($fFinal."- 0 days"));
        
        $col1 = date('d/m/Y', strtotime($fFinal."- 6 days"));
        $col2 = date('d/m/Y', strtotime($fFinal."- 5 days"));
        $col3 = date('d/m/Y', strtotime($fFinal."- 4 days"));
        $col4 = date('d/m/Y', strtotime($fFinal."- 3 days"));
        $col5 = date('d/m/Y', strtotime($fFinal."- 2 days"));
        $col6 = date('d/m/Y', strtotime($fFinal."- 1 days"));
        $col7 = date('d/m/Y', strtotime($fFinal."- 0 days"));
        
        $inicio1 = date('Ymd', strtotime($fFinal."- 6 days"));
        if ($inicio1 != date('d/m/Y')){
            $inicio1 = $inicio1.' 23:59:59';
        }
        
        $inicio2 = date('Ymd', strtotime($fFinal."- 5 days"));
        if ($inicio2 != date('d/m/Y')){
            $inicio2 = $inicio2.' 23:59:59';
        }
        
        $inicio3 = date('Ymd', strtotime($fFinal."- 4 days"));
        if ($inicio3 != date('d/m/Y')){
            $inicio3 = $inicio3.' 23:59:59';
        }
        
        $inicio4 = date('Ymd', strtotime($fFinal."- 3 days"));
        if ($inicio4 != date('d/m/Y')){
            $inicio4 = $inicio4.' 23:59:59';
        }
        
        $inicio5 = date('Ymd', strtotime($fFinal."- 2 days"));
        if ($inicio5 != date('d/m/Y')){
            $inicio5 = $inicio5.' 23:59:59';
        }
        
        $inicio6 = date('Ymd', strtotime($fFinal."- 1 days"));
        if ($inicio6 != date('d/m/Y')){
            $inicio6 = $inicio6.' 23:59:59';
        }
        
        $inicio7 = $fFinal;
        
        $descripcionRango = 'RANGO DE FECHAS - [ ';
        if ($mes1 != $mes7){
            $descripcionRango .= $this->obtenerNombreMes($mes1).' : '.$this->obtenerNombreMes($mes7).' ]';
        }
        else{
            $descripcionRango .= $this->obtenerNombreMes($mes1).' ]';
        }
        
        
        $saldo1 = $col1;
        $saldo2 = $col2;
        $saldo3 = $col3;
        $saldo4 = $col4;
        $saldo5 = $col5;
        $saldo6 = $col6;
        $saldo7 = $col7;
        
        $columnas = [
            'DescripcionRango' => $descripcionRango,
            'Saldo1' => $saldo1,
            'Saldo2' => $saldo2,
            'Saldo3' => $saldo3,
            'Saldo4' => $saldo4,
            'Saldo5' => $saldo5,
            'Saldo6' => $saldo6,
            'Saldo7' => $saldo7,
        ];
        
        $nom = '';
        if ($request->get('nom') != null){
            $nom = $request->get('nom');
        }
        
        $datos = (new CajaController())->PA_ReporteInsumos_AlaFecha($inicio1, $inicio2, $inicio3, $inicio4, $inicio5, $inicio6, $inicio7, $fFinal, $cat, $panel, $nom, $tipo);
        $categorias = (new CajaController())->PA_ListarCategorias_PorTipoWEB('INSUMOS');
        $descripCaja = 'REPORTE DE INSUMOS A LA FECHA';
        
        return view('Reportes.RptInsumos', compact('user', 'datos', 'descripCaja', 'categorias', 'cat', 'hasta', 'columnas', 'nom'));
    }
}

