<?php

namespace App\Services;
use Codedge\Fpdf\Fpdf\Fpdf;

// use Codedge\Fpdf\Fpdf\Fpdf;
use DateTime;
use Mockery\Undefined;

use NumeroALetras;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelLow;
use Endroid\QrCode\RoundBlockSizeMode\RoundBlockSizeModeMargin;
use Endroid\QrCode\Label\Alignment\LabelAlignmentCenter;
use Endroid\QrCode\Label\Font\NotoSans;


require_once 'NumeroALetras.php';


date_default_timezone_set('America/Lima');


function fechaLetras($fecha)
{
    if ($fecha == "" || $fecha == null) {
        return "-";
    }
    // Convertir la fecha a objeto DateTime
    $fechaDateTime = new DateTime($fecha);

    // Obtener el día en formato "dd"
    $letras = $fechaDateTime->format('d');
    $letras .= " DE ";

    // Obtener el mes en formato "MM" y convertirlo a nombre del mes en español
    $mesNumero = $fechaDateTime->format('m');
    switch ($mesNumero) {
        case "01":
            $letras .= "ENERO";
            break;
        case "02":
            $letras .= "FEBRERO";
            break;
        case "03":
            $letras .= "MARZO";
            break;
        case "04":
            $letras .= "ABRIL";
            break;
        case "05":
            $letras .= "MAYO";
            break;
        case "06":
            $letras .= "JUNIO";
            break;
        case "07":
            $letras .= "JULIO";
            break;
        case "08":
            $letras .= "AGOSTO";
            break;
        case "09":
            $letras .= "SEPTIEMBRE";
            break;
        case "10":
            $letras .= "OCTUBRE";
            break;
        case "11":
            $letras .= "NOVIEMBRE";
            break;
        case "12":
            $letras .= "DICIEMBRE";
            break;
    }

    $letras .= " DEL ";
    $letras .= $fechaDateTime->format('Y');

    return $letras;
}

class PDF_Dash extends FPDF
{
    function SetDash($black = null, $white = null)
    {
        if ($black !== null)
            $s = sprintf('[%.3F %.3F] 0 d', $black * $this->k, $white * $this->k);
        else
            $s = '[] 0 d';
        $this->_out($s);
    }
}
class PDFService
{
    public function createPDF($data)
    {

        $formatter = new NumeroALetras();

        //$formatter = new NumeroALetras();

        $ruc_empresa = "20559848167";

        $cabecera = $data["cabecera"][0];
        $detalles = $data["detalles"];

        $pdf = new PDF_Dash('P', 'mm');
        $pdf->AddPage('P', 'A4');
        $pdf->SetFont('Arial', 'B', 16);

        $fontSize = 10;
        $paddingGeneral = 10;

        $inicio = $paddingGeneral * 3.7;
        $fin = $pdf->GetPageWidth() * 0.47;

        $pdf->SetY($paddingGeneral);
        $ruta_logo = base_path('app/Services/uriol-logo.png');
        // imprimirImagen($pdf, $inicio, $fin, "../app/Services/uriol-logo.png", 0);
        imprimirImagen($pdf, $inicio, $fin, $ruta_logo, 0);
        $y = $pdf->GetY();
        $esBoletaOFactura = ($cabecera["VEN_TipoDocumento"] == "BOLETA" || $cabecera["VEN_TipoDocumento"] == "FACTURA") ? true : false;

        $tipoDeDocumento = $cabecera["VEN_TipoDocumento"];
        if ($esBoletaOFactura) {
            $tipoDeDocumento .= " ELECTRÓNICA";
        }

        $pdf->SetY($paddingGeneral);
        $posicionA = [(($pdf->GetPageWidth() * 0.6) - ($paddingGeneral * 0.25)), $pdf->GetY()];
        $posicionB = [$pdf->GetPageWidth() - $paddingGeneral, $pdf->GetY()];
        $inicio = $pdf->GetPageWidth() * 0.6;
        $fin = $pdf->GetPageWidth() - $paddingGeneral * 1.25;
        $pdf->SetY($paddingGeneral * 1.25);
        imprimirTextoMultilinea($pdf, "RUC: " . $ruc_empresa, "", $fontSize * 1.20, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, $tipoDeDocumento, "B", $fontSize * 1.20, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, $cabecera["VEN_Serie"], "", $fontSize * 1.20, "C", 0, $inicio, $fin);
        //imprimirTextoMultilinea($pdf, json_encode($data), "", $fontSize * 1.20, "C", 0, $inicio, $fin);
        // imprimirTextoMultilinea($pdf, json_encode($cabecera), "", $fontSize * 1.20, "C", 0, $inicio, $fin);
        // imprimirTextoMultilinea($pdf, json_encode($data), "", $fontSize * 1.20, "C", 0, $inicio, $fin);
        //imprimirTextoMultilinea($pdf, $cabecera["VEN_TipoDocumento"], "", $fontSize * 1.20, "C", 0, $inicio, $fin);
        // imprimirTextoMultilinea($pdf, $data["empresa"], "", $fontSize * 1.20, "C", 0, $inicio, $fin);

        saltarDeLinea($pdf, 2.5);

        $posicionC = [(($pdf->GetPageWidth() * 0.6) - ($paddingGeneral * 0.25)), $pdf->GetY()];
        $posicionD = [$pdf->GetPageWidth() - $paddingGeneral, $pdf->GetY()];
        imprimirRectangulo($pdf, 0, $posicionA, $posicionB, $posicionC, $posicionD);


        $pdf->SetY($y);
        saltarDeLinea($pdf, 5);


        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() * 0.6;
        $y = $pdf->GetY();

        imprimirTextoMultilinea($pdf, "VENTAS DE REPUESTOS AUTOMOTRIZ", "", $fontSize * 0.6, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "FAJA - RODAJES - AMORTIGUADORES - MUELLES", "", $fontSize * 0.6, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "REPARACIÓN COMPLETA PARA TODO TIPO DE VEHÍCULOS", "", $fontSize * 0.6, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "CONTACTO: 000 000 000", "B", $fontSize * 0.75, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "CAL. CAJAMARCA NRO. 116 CENTRO CHEPEN - CHEPEN - LA LIBERTAD", "B", $fontSize * 0.75, "C", 0, $inicio, $fin);
        $y = $y - 5;
        $pdf->SetY($y + 1.5);
        $inicio = $pdf->GetPageWidth() * 0.66;
        $fin = $pdf->GetPageWidth() * 0.81;
        $ruta = base_path('app/Services/castrol.png');
        imprimirImagen($pdf, $inicio, $fin, $ruta, 0);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8325;
        $fin = $pdf->GetPageWidth() * 0.89;
        $ruta = base_path('app/Services/nisan.png');
        imprimirImagen($pdf, $inicio, $fin, $ruta, 0);

        $y = $pdf->GetY();
        $y = $y + 2.5;
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.69;
        $fin = $pdf->GetPageWidth() * 0.78;
        $ruta = base_path('app/Services/hiunday.png');
        imprimirImagen($pdf, $inicio, $fin, $ruta, 0);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.82;
        $fin = $pdf->GetPageWidth() * 0.9;
        $ruta = base_path('app/Services/jac.png');
        imprimirImagen($pdf, $inicio, $fin, $ruta, 0);



        saltarDeLinea($pdf, 5);
        $posicionA = [$paddingGeneral, $pdf->GetY()];
        $posicionB = [$pdf->GetPageWidth() - $paddingGeneral, $pdf->GetY()];

        saltarDeLinea($pdf, 5);
        $y = $pdf->GetY();
        $inicio = $paddingGeneral * 1.5;
        $fin = $pdf->GetPageWidth() * 0.18;
        imprimirTextoMultilinea($pdf, "FECHA", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.18;
        $fin = $pdf->GetPageWidth() * 0.2;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.2;
        $fin = $pdf->GetPageWidth() * 0.5;
        imprimirTextoMultilinea($pdf, fechaLetras($cabecera["VEN_FechaEmision"]), "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.525;
        $fin = $pdf->GetPageWidth() * 0.64;
        imprimirTextoMultilinea($pdf, "CONDICION", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.64;
        $fin = $pdf->GetPageWidth() * 0.66;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.66;
        $fin = $pdf->GetPageWidth() - ($paddingGeneral * 1.5);
        imprimirTextoMultilinea($pdf, $cabecera["VEN_Condicion"], "", $fontSize * 1, "L", 0, $inicio, $fin);



        $y = $pdf->GetY();
        $inicio = $paddingGeneral * 1.5;
        $fin = $pdf->GetPageWidth() * 0.18;
        imprimirTextoMultilinea($pdf, "R.U.C.", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.18;
        $fin = $pdf->GetPageWidth() * 0.2;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.2;
        $fin = $pdf->GetPageWidth() * 0.5;
        imprimirTextoMultilinea($pdf, $cabecera["cli_nro_doc"], "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.525;
        $fin = $pdf->GetPageWidth() * 0.64;
        imprimirTextoMultilinea($pdf, "F. VCTO", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.64;
        $fin = $pdf->GetPageWidth() * 0.66;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.66;
        $fin = $pdf->GetPageWidth() - ($paddingGeneral * 1.5);
        imprimirTextoMultilinea($pdf, fechaLetras($cabecera["VEN_FechaVencimiento"]), "", $fontSize * 1, "L", 0, $inicio, $fin);


        $y = $pdf->GetY();
        $inicio = $paddingGeneral * 1.5;
        $fin = $pdf->GetPageWidth() * 0.18;
        imprimirTextoMultilinea($pdf, "SEÑOR(ES)", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.18;
        $fin = $pdf->GetPageWidth() * 0.2;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.2;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, $cabecera["cli_razon_social"], "", $fontSize * 1, "L", 0, $inicio, $fin);



        $y = $pdf->GetY();
        $inicio = $paddingGeneral * 1.5;
        $fin = $pdf->GetPageWidth() * 0.18;
        imprimirTextoMultilinea($pdf, "DIRECCION", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.18;
        $fin = $pdf->GetPageWidth() * 0.2;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.2;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, $cabecera["cli_direccion"], "", $fontSize * 1, "L", 0, $inicio, $fin);



        // $y = $pdf->GetY();
        // $inicio = $paddingGeneral * 1.5;
        // $fin = $pdf->GetPageWidth() * 0.18;
        // imprimirTextoMultilinea($pdf, "GLOSA", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        // $pdf->SetY($y);
        // $inicio = $pdf->GetPageWidth() * 0.18;
        // $fin = $pdf->GetPageWidth() * 0.2;
        // imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        // $pdf->SetY($y);
        // $inicio = $pdf->GetPageWidth() * 0.2;
        // $fin = $pdf->GetPageWidth() * 0.5;
        // imprimirTextoMultilinea($pdf, "-", "", $fontSize * 1, "L", 0, $inicio, $fin);

        saltarDeLinea($pdf, 5);

        $posicionC = [$paddingGeneral, $pdf->GetY()];
        $posicionD = [$pdf->GetPageWidth() - $paddingGeneral, $pdf->GetY()];
        imprimirRectangulo($pdf, 0, $posicionA, $posicionB, $posicionC, $posicionD);

        saltarDeLinea($pdf, 5);


        $y = $pdf->GetY();
        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() * 0.15;
        imprimirTextoMultilinea($pdf, "CANT.", "B", $fontSize * 1, "C", 1, $inicio, $fin);

        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.15;
        $fin = $pdf->GetPageWidth() * 0.3;
        imprimirTextoMultilinea($pdf, "UNID.", "B", $fontSize * 1, "C", 1, $inicio, $fin);

        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.3;
        $fin = $pdf->GetPageWidth() * 0.65;
        imprimirTextoMultilinea($pdf, "DESCRIPCIÓN", "B", $fontSize * 1, "C", 1, $inicio, $fin);

        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.65;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "PRECIO (S/)", "B", $fontSize * 1, "C", 1, $inicio, $fin);

        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, "TOTAL (S/)", "B", $fontSize * 1, "C", 1, $inicio, $fin);



        $productos = array(
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            )
        );

        $posiciones_y = array();

        $sub_total = 0;

        // >>>>>>>>>> FILAS DE PRODUCTOS <<<<<<<<<<<
        for ($i = 0; $i < count($detalles); ++$i) {
            $detalle = $detalles[$i];
            $y = ($i > 0 ? max($posiciones_y) : $pdf->GetY());
            $y += 1.25;

            if ($y > 260) {
                $pdf->AddPage();
                $y = $y - 260 + 10;
                $pdf->SetXY(0, $y);
                $posiciones_y = array();
            }

            //$y = $pdf->GetY();

            $pdf->SetXY(0, $y);
            $inicio = $paddingGeneral;
            $fin = $pdf->GetPageWidth() * 0.15;

            $cantidad = $detalle["DVEN_Cantidad"] * 1;
            $precioVenta = $detalle["DVEN_PrecioVenta"] * 1;
            $importe = $detalle["DVEN_Importe"] * 1;

            imprimirTextoMultilinea($pdf, $cantidad, "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $pdf->SetXY(0, $y);
            $inicio = $pdf->GetPageWidth() * 0.15;
            $fin = $pdf->GetPageWidth() * 0.3;
            imprimirTextoMultilinea($pdf, $detalle["DVEN_Unidad"], "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $pdf->SetXY(0, $y);
            $inicio = $pdf->GetPageWidth() * 0.3;
            $fin = $pdf->GetPageWidth() * 0.65;
            imprimirTextoMultilinea($pdf, $detalle["DVEN_Descripcion"], "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $pdf->SetXY(0, $y);
            $inicio = $pdf->GetPageWidth() * 0.65;
            $fin = $pdf->GetPageWidth() * 0.8;
            imprimirTextoMultilinea($pdf, number_format($precioVenta, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $pdf->SetXY(0, $y);
            $inicio = $pdf->GetPageWidth() * 0.8;
            $fin = $pdf->GetPageWidth() - $paddingGeneral;
            imprimirTextoMultilinea($pdf, number_format($importe, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $sub_total += $importe;
        }
        if ($posiciones_y) {
            $y = max($posiciones_y);
            $pdf->SetXY(0, $y);
        }

        saltarDeLinea($pdf, 4);
        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirLineaHorizontal($pdf, $inicio, $fin);
        saltarDeLinea($pdf, 4);


        $y = $pdf->getY();

        $con_letra = $formatter->toInvoice($cabecera["VEN_Total"] * 1, 2, 'SOLES');
        $con_letra = "SON " . $con_letra;
        $con_letra = strtr($con_letra, "\\", "");

        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() * 0.25;
        imprimirTextoMultilinea($pdf, "LEYENDA", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        saltarDeLinea($pdf, 0);
        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() * 0.50;
        imprimirTextoMultilinea($pdf, $con_letra, "", $fontSize * 1, "L", 0, $inicio, $fin);

        $posicionYQR = $pdf->GetY();

        $operacionesGravadas = $sub_total / 1.18;
        $igv = $sub_total - $operacionesGravadas;

        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "OP: GRAVADAS:                   S/", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format($cabecera["VEN_SubTotal"], 2), "", $fontSize * 1, "C", 0, $inicio, $fin);



        $y = $pdf->getY();
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "OP: EXONERADAS:              S/", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format(0, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);


        $y = $pdf->getY();
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "OP: INAFECTAS:                   S/", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format(0, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);


        $y = $pdf->getY();
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "IGV:                                        S/", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format($cabecera["VEN_Igv"], 2), "", $fontSize * 1, "C", 0, $inicio, $fin);
        // imprimirTextoMultilinea($pdf, number_format($sub_total * 0.18, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);
        // imprimirTextoMultilinea($pdf, 'sub_total:' . $sub_total . " | sub_total/1.18:" . $sub_total / 1.18 . " | sub_total*0.18:" . $sub_total * 0.18, "", $fontSize * 1, "C", 0, $inicio, $fin);


        saltarDeLinea($pdf, 4);
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirLineaHorizontal($pdf, $inicio, $fin);
        saltarDeLinea($pdf, 4);
        //$pdf->SetY($y);


        $y = $pdf->getY();
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "IMPORTE TOTAL:                 S/", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format($cabecera["VEN_Total"], 2), "B", $fontSize * 1, "C", 0, $inicio, $fin);

        if ($esBoletaOFactura) {
            // $pdf->SetY($posicionYQR);
            // $inicio = $paddingGeneral;
            // $fin = $pdf->GetPageWidth() * 0.2;
            // $ruta = base_path('app/Services/qr.png');
            // imprimirImagen($pdf, $inicio, $fin, $ruta, 0);
            $tipoDoc = $cabecera["VEN_TipoDocumento"] == "BOLETA" ? "03" : "01";

            $cantidadDeDigitos = strlen(trim($cabecera["cli_nro_doc"]));

            $tipoDocCliente = "";
            if ($cantidadDeDigitos == 8) {
                $tipoDocCliente = "01";
            } else if ($cantidadDeDigitos == 11) {
                $tipoDocCliente = "06";
            }

            // Crear un objeto DateTime a partir de la cadena original
            $VEN_FechaEmision_DateTime = DateTime::createFromFormat('M d Y h:i:s:uA', $cabecera["VEN_FechaEmision"]);
            $VEN_FechaEmision_Formateada = $VEN_FechaEmision_DateTime->format('Y-m-d');

            $qrData = $ruc_empresa . '|' . $tipoDoc . '|' . $cabecera["VEN_Serie"] . '|' . number_format($cabecera["VEN_Igv"], 2) . '|' . number_format($cabecera["VEN_Total"], 2) . '|' . $VEN_FechaEmision_Formateada . '|' . $tipoDocCliente . '|' . $cabecera["cli_nro_doc"];

            generarQr($qrData);

            $ruta = base_path('app/Services/qr.png');

            $pdf->SetY($posicionYQR);
            $inicio = $paddingGeneral;
            $fin = $pdf->GetPageWidth() * 0.3;
            imprimirImagen($pdf, $inicio, $fin, $ruta, 0);
        }

        // $this->Output('F', 'archivo.pdf'); // El segundo parámetro 'D' indica que se descargará el archivo
        $pdf->Output();
    }
}

function generarQr($data) {
    $qrCode = QrCode::create($data)
        ->setEncoding(new Encoding('UTF-8'))
        ->setErrorCorrectionLevel(new ErrorCorrectionLevelLow())
        ->setSize(300)
        ->setMargin(10)
        ->setRoundBlockSizeMode(new RoundBlockSizeModeMargin());

    $writer = new PngWriter();
    $result = $writer->write($qrCode);

    // Guarda la imagen en la ruta especificada
    $result->saveToFile(base_path('app/Services/qr.png'));
}


function imp($text)
{
    $text = iconv('UTF-8', 'windows-1252', $text);
    return $text;
}

function centrarTexto($pdf, $text, $lineHeight, $b, $font_size)
{
    $ancho_del_ticket = $pdf->GetPageWidth(1);
    $pdf->SetFont('helvetica', $b, $font_size);
    $pdf->SetX(0);
    $pdf->MultiCell($ancho_del_ticket, $lineHeight, imp($text), 0, 'C', '');
}

function imprimirTextoMultilinea($pdf, $text, $b, $fontSize, $textAlign, $border, $start, $end)
{
    // Calcular la altura de línea basada en el tamaño de fuente
    $lineHeight = $fontSize * 0.5; // Por ejemplo, 1.5 veces el tamaño de fuente

    $pdf->SetFont('helvetica', $b, $fontSize);
    $pdf->SetX($start);
    $pdf->MultiCell($end - $start, $lineHeight, strtoupper(imp($text)), $border, $textAlign, '');
}

function imprimirImagen($pdf, $start, $end, $ruta_imagen, $padding)
{
    // Obtener la información de la imagen original
    list($originalWidth, $originalHeight) = getimagesize($ruta_imagen);

    // Calcular el ancho en función de la altura y la relación de aspecto
    $aspectRatio = $originalWidth / $originalHeight;
    $alto_de_la_imagen = ($end - $start) / $aspectRatio;

    // Obtener la posición actual de Y
    $y = $pdf->GetY();

    // Ajustar las coordenadas y dimensiones con el padding
    $x = $start + $padding;
    $y += $padding;
    $ancho = $end - $start - 2 * $padding;
    $alto = $alto_de_la_imagen - 2 * $padding;

    // Insertar la imagen en la página
    $pdf->Image($ruta_imagen, $x, $y, $ancho, $alto);

    // Calcular el siguiente valor de Y sumando el alto de la imagen y el padding
    $siguiente_y = $y + $alto + $padding;

    // Ajustar la posición Y para el siguiente elemento
    $pdf->SetY($siguiente_y);
}

function saltarDeLinea($pdf, $numeroDeSaltos)
{
    $y_actual = $pdf->GetY();
    $pdf->Ln($numeroDeSaltos);
    $pdf->SetY($y_actual + $numeroDeSaltos);
}

function imprimirLineaHorizontal($pdf, $inicioX, $finX, $alturaY = null)
{
    // Si no se proporciona la altura Y, se establece un valor predeterminado
    if ($alturaY === null) {
        $alturaY = $pdf->GetY();
    }

    $pdf->SetLineWidth(0);
    $pdf->SetDash(0, 0);
    $pdf->SetFont('helvetica', '', 5);
    $pdf->Line($inicioX, $alturaY, $finX, $alturaY);
}


function imprimirRectangulo($pdf, $espacioEntreLineas, $posicionA, $posicionB, $posicionC, $posicionD)
{
    // $pdf->SetLineWidth(0.1);
    $pdf->SetDash($espacioEntreLineas, $espacioEntreLineas);
    // LINEA HORIZONTAL SUPERIOR
    $pdf->Line($posicionA[0], $posicionA[1], $posicionB[0], $posicionB[1]);

    // LINEA VERTICAL A LA IZQUIERDA
    $pdf->Line($posicionA[0], $posicionA[1], $posicionC[0], $posicionC[1]);

    // LINEA HORIZONTAL INFERIOR
    $pdf->Line($posicionC[0], $posicionC[1], $posicionD[0], $posicionD[1]);

    // LINEA VERTICAL A LA DERECHA
    $pdf->Line($posicionB[0], $posicionB[1], $posicionD[0], $posicionD[1]);
}
