@extends('index')
@section('estilos')
<link rel="stylesheet" href="/files/calendario/css/bootstrap-datepicker.standalone.css">
<link rel="stylesheet" href="/files/librerias/jquery-ui/jquery-ui.min.css">
<style>
    .fuenteBuscador {
        font-family: Arial, Helvetica, sans-serif;
        font-size: 11pt;
        font-style: italic
    }

    .input-wrapper {
        position: relative;
    }

    .input-icon {
        color: darkgray;
        position: absolute;
        width: 25px;
        height: 25px;
        left: 12px;
        top: 75%;
        transform: translateY(-50%);
    }

    .input {
        box-sizing: border-box;
        color: #191919;
        padding: 15px 15px 15px 35px;
        width: 100%;
    }
</style>
@endsection
@section('contenido')
<div class="container-fluid">
    @if (session('good'))
    <div class="alert alert-success alert-dissmissible fade show" role="alert">
        {{ session('good') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif
    @if (session('error'))
    <div class="alert alert-danger alert-dissmissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif

    <form id="frmVentas" action="">
        <div class="row" style="margin-top: -10pt">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" id="pnlAtencion">
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-dollar-sign text-info"></i>
                        <span class="letra">Registro de Ventas</span>
                    </div>
                    <div class="card-body border shadow">
                        <div class="row" style="margin-top: -10px">
                            <div class="col-md-2 col-12">
                                <label for="">Desde:</label>
                                <div class="input-group date form_date" data-date-format="dd/mm/yyyy" data-provide="datepicker">
                                    <input readonly type="text" class="form-control" name="desde" id="desde" data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy" data-mask="" im-insert="false" value="{{ $desde }}" placeholder="dd/mm/yyyy">
                                    <div class="input-group-btn">
                                        <button class="btn btn-primary date-set" type="button">
                                            <i class="fa fa-calendar"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2 col-12">
                                <label for="">Hasta:</label>
                                <div class="input-group date form_date" data-date-format="dd/mm/yyyy" data-provide="datepicker">
                                    <input readonly type="text" class="form-control" name="hasta" id="hasta" data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy" data-mask="dd/mm/yyyy" im-insert="false" value="{{ $hasta }}" placeholder="dd/mm/yyyy">
                                    <div class="input-group-btn">
                                        <button class="btn btn-primary date-set" type="button">
                                            <i class="fa fa-calendar"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2 col-12">
                                <label for="tipoDocumento">Tipo de Documento:</label>
                                <select class="form-control" id="tipoDocumento" name="tipoDocumento">
                                    @foreach($documentTypes as $option)
                                    <option value="{{ $option }}" {{ ($documentTypeSelected == $option) ? 'selected' : '' }}>
                                        {{ ($option == '') ? 'TODOS' : $option }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-4 col-12">
                                <label>Cliente:&nbsp;</label><span id="waiting"></span>
                                <a class="float-right text-blue" onclick="limpiarCliente();" style="cursor: pointer">Cambiar</a>
                                <input type="text" name="idcliente" id="idcliente" hidden @if($idcliente !=null) value="{{ $idcliente }}" @endif>
                                <input type="search" id="txtCliente" class="form-control fuenteBuscador input" placeholder="Buscar por documento o razón social..." @if($idcliente !=null) readonly value="{{ $docCliente.' - '.$docRazonSocial }}" @endif></input>
                                <svg xmlns="http://www.w3.org/2000/svg" class="input-icon" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <div class="col-md-2 col-12">
                                <label for="" class="d-none d-sm-block">&nbsp;</label>
                                <label for="" class="d-block d-sm-none"></label>
                                <button type="submit" class=" form-control btn btn-primary">
                                    <i class="fas fa-search"></i> Filtrar </button>
                            </div>
                        </div>
                    </div>
                    <div class="card-body border shadow">
                        <div class="row">
                            <div class="col-md-12">
                                <span class="d-block d-sm-none" style="font-size: 10pt">
                                    Deslizar tabla a la der/izq para más detalles.
                                </span>
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead class="bg-secondary" style="font-size: 10pt">
                                            <tr>
                                                <th style="width: 130pt">Fecha&nbsp;de&nbsp;Emisión&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
                                                <th>Nº&nbsp;Documento</th>
                                                <th>Cliente&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
                                                <th>Condición</th>
                                                <th class="text-right">Total</th>
                                                <th class="text-center">Acción</th>
                                            </tr>
                                        </thead>
                                        <tbody style="font: Arial; font-size: 10pt;">
                                            @foreach ($ventas as $key => $item)
                                            <tr>
                                                <td>{{ $item['fecha_sistema'] }}</td>
                                                <td>{{ $item['nroventa'] }}</td>
                                                <td>{{ $item['doccliente'].' - '.$item['cliente'] }}</td>
                                                <td>{{ $item['condicion'] }}</td>
                                                <td class="text-right">{{ number_format($item['total'], 2) }}</td>
                                                <td class="text-center">
                                                    <div class="btn-group">
                                                        <button type="button" class="btn btn-info btn-sm dropdown-toggle" data-toggle="dropdown" data-boundary="window" aria-haspopup="true" aria-expanded="false">
                                                            <i class="fas fa-tasks"></i>
                                                        </button>
                                                        <div class="dropdown-menu">
                                                            <a class="dropdown-item" href="javascript:;" onclick="btnVerDocVenta('{{ $item['idventa'] }}', '{{ $item['nroventa'] }}')"><i class="fas fa-list text-primary"></i> Ver Detalle</a>
                                                            <div class="dropdown-divider"></div>
                                                            <!-- <a class="dropdown-item" href="javascript:;" onclick="btnDescargarArchivo('{{ $item['idventa'] }}', 'PDF')"><i class="fas fa-file-pdf text-red"></i> Descargar PDF</a> -->
                                                            <a class="dropdown-item" href="javascript:;" onclick="btnDescargarPDF('{{ $item['idventa'] }}')"><i class="fas fa-file-code text-blue"></i> Descargar PDF</a>
                                                            <a class="dropdown-item" href="javascript:;" onclick="btnDescargarArchivo('{{ $item['idventa'] }}', 'XML')"><i class="fas fa-file-code text-blue"></i> Descargar XML</a>
                                                            <a class="dropdown-item" href="javascript:;" onclick="btnDescargarArchivo('{{ $item['idventa'] }}', 'CDR')"><i class="fas fa-file-archive text-blue"></i> Descargar CDR</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 col-6 text-center" style="padding-top: 7px">
                                        <label for="" style="color: blue">Contado: s/.</label>
                                    </div>
                                    <div class="col-md-2 col-6">
                                        <input type="text" class="form-control text-center text-bold" style="font-size: 12pt" readonly="readonly" value="{{ number_format($contado, 2) }}">
                                    </div>
                                    <div class="col-md-2 col-6 text-center" style="padding-top: 7px">
                                        <label for="" style="color: red">Crédito: s/.</label>
                                    </div>
                                    <div class="col-md-2 col-6">
                                        <input type="text" class="form-control text-center text-bold" style="font-size: 12pt" readonly="readonly" value="{{ number_format($credito, 2) }}">
                                    </div>
                                    <div class="col-md-2 col-6 text-center" style="padding-top: 7px">
                                        <label for="">Total: s/.</label>
                                    </div>
                                    <div class="col-md-2 col-6">
                                        <input type="text" class="form-control text-center text-bold" style="font-size: 12pt" readonly="readonly" value="{{ number_format($total, 2) }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@include('Ventas.modalVerDetalle')
@endsection
@section('scripts')
<script src="/files/calendario/js/bootstrap-datepicker.min.js"></script>
<script src="/files/calendario/locales/bootstrap-datepicker.es.min.js"></script>
<script src="/files/librerias/jquery-ui/jquery-ui.min.js"></script>

<script>
    async function btnVerDocVenta(_Codigo, _NroDoc) {
        try {
            mostrarCargando('Procesando...');

            // Actualizar el número de documento
            $('#nrodoc').html(_NroDoc);
            $('#tblbodyDetalles').html('');

            // Primer AJAX para obtener detalles de venta por código
            const responseDetalles = await $.ajax({
                type: "GET",
                url: RUTA_API + "PA_ObtenerDetallesVenta_PorCodigo/" + _Codigo,
                dataType: "JSON"
            });

            const detalles = responseDetalles.detalles;

            var x = 1;
            var totalCosto = 0;
            var totalVenta = 0;

            // Construir filas de detalles
            detalles.forEach(element => {
                var fila = construirFilaDetalle(x, element.DVEN_Descripcion, parseFloat(element.DVEN_Cantidad),
                    element.DVEN_Unidad, parseFloat(element.DVEN_PrecioVenta).toFixed(2), element.DVEN_Importe);
                $('#tblDetalleVentas').append(fila);

                totalCosto += parseFloat(element.DVEN_Cantidad) * parseFloat(element.DVEN_PrecioCosto);
                totalVenta += parseFloat(element.DVEN_Importe);
                x++;
            });

            // Actualizar totales
            $('#totalDetalleVenta').val(totalVenta.toFixed(2));
            $('#totalDetalleCosto').val(totalCosto.toFixed(2));
            $('#totalDetalleGanancia').val((totalVenta - totalCosto).toFixed(2));

            // Segundo AJAX para obtener cabecera de venta por código
            const responseCabecera = await $.ajax({
                type: "GET",
                url: RUTA_API + "PA_ObtenerVenta_PorCodigo_Cabecera/" + _Codigo,
                dataType: "JSON"
            });

            const cabecera = responseCabecera.cabecera[0];

            // Actualizar elementos en el modal con la cabecera obtenida
            $("#nroPedido").html(cabecera.PED_Nro);
            $("#dniRuc").html(cabecera.cli_nro_doc);
            $("#cliente").html(cabecera.cli_razon_social);
            $("#direccion").html(cabecera.cli_direccion);
            // $("#direccion").html("AVENIDA PETITUAR 4875 COLEGIO DANIEL");
            $("#fecha").html(formatearFecha(cabecera.VEN_FechaEmision));
            $("#condicion").html(cabecera.VEN_Condicion);
            $("#fechaVencimiento").html(formatearFecha(cabecera.VEN_FechaVencimiento));
            $("#moneda").html(cabecera.VEN_Moneda);
            $("#tc").html(cabecera.VEN_TipoCambio);
            $("#vendedor").html("VENDEDOR: " + cabecera.Vendedor + " | CAJERO: " + cabecera.Cajero);
            $("#observaciones").html(cabecera.VEN_Observaciones);
            $("#opGravadas").html(cabecera.VEN_SubTotal);
            $("#igv").html(cabecera.VEN_Igv);
            $("#total").html(cabecera.VEN_Total);

            // Asignar evento onclick al botón de descargar PDF
            $('#btnDescargarPDF').attr('onclick', "btnDescargarPDF('" + _Codigo + "')");

            // Mostrar el modal después de obtener y actualizar toda la información
            $('#modalVerDetalle').modal('show');

        } catch (error) {
            alert('- Error al obtener detalle de venta');
            console.log(error);
        } finally {
            cerrarCangando();
        }
    }

    function formatearFecha(fechaOriginal) {
        // console.log("fechaOriginal:", fechaOriginal);
        fechaOriginal = fechaOriginal.trim();
        if (fechaOriginal == null || fechaOriginal == undefined || fechaOriginal == "") {
            return '';
        }

        // Regex para separar la fecha y la hora
        const fechaHoraRegex = /^(\w{3}) (\d{1,2}) (\d{4}) (\d{2}):(\d{2}):(\d{2}):(\d{3})(AM|PM)$/;
        const match = fechaOriginal.match(fechaHoraRegex);

        if (!match) {
            return '';
        }

        const [_, mes, dia, año] = match;

        // Convertir el nombre del mes a un número
        const meses = {
            Jan: 0,
            Feb: 1,
            Mar: 2,
            Apr: 3,
            May: 4,
            Jun: 5,
            Jul: 6,
            Aug: 7,
            Sep: 8,
            Oct: 9,
            Nov: 10,
            Dec: 11
        };

        const mesNumero = meses[mes];

        // Crear una fecha con los valores extraídos
        const fecha = new Date(año, mesNumero, dia);

        // console.log("fecha:", fecha);

        const diaFormateado = ("0" + fecha.getDate()).slice(-2);
        const mesFormateado = ("0" + (fecha.getMonth() + 1)).slice(-2); // Los meses van de 0 a 11
        const añoFormateado = fecha.getFullYear();

        const fechaFormateada = `${diaFormateado}/${mesFormateado}/${añoFormateado}`;
        // console.log("fechaFormateada:", fechaFormateada);

        return fechaFormateada;
    }

    function construirFilaDetalle(item, nombre, cantidad, unidad, venta, importeventa) {
        var contenido = '<tr>';
        contenido += '<td style="width: 40pt" class="text-center">' + cantidad + '</td>';
        contenido += '<td style="width: 40pt" class="text-center">' + unidad + '</td>';
        contenido += '<td> ' + nombre + '</td>';
        contenido += '<td style="width: 50pt" class="text-right">' + venta + '</td>';
        contenido += '<td style="width: 50pt" class="text-right">' + parseFloat(importeventa).toFixed(2) + '</td>';
        contenido += '</tr>';
        return contenido;
    }

    async function btnDescargarPDF(_Codigo) {
        var dataVenta = null;

        $.ajax({
            type: "GET",
            url: RUTA_API + "PA_ObtenerVenta_PorCodigo/" + _Codigo,
            dataType: "JSON",
            success: function(data) {
                dataVenta = data;
                // console.log("PA_ObtenerVenta_PorCodigo => data:", data);

                // Verificar si se encontró la venta
                if (dataVenta == null) {
                    alert("No se encontró la venta en el sistema");
                    return;
                }

                // Llamar al segundo AJAX para generar el PDF
                $.ajax({
                    type: "POST",
                    url: RUTA_API + "GenerarPDF",
                    data: JSON.stringify(dataVenta),
                    contentType: "application/json",
                    xhrFields: {
                        responseType: 'blob'
                    },
                    success: function(data) {
                        // Opcion 1 : Mostrar el PDF en otra ventana
                        // console.log("GenerarPDF => url:", RUTA_API + "GenerarPDF");
                        // console.log("GenerarPDF => data:", data);

                        // var blob = new Blob([data], {
                        //     type: 'application/pdf'
                        // });

                        // var url = window.URL.createObjectURL(blob);
                        // window.open(url);
                        // return;

                        // Opcion 2 : Descargar automáticamente el PDF
                        var blob = new Blob([data], {
                            type: 'application/pdf'
                        });
                        var link = document.createElement('a');
                        link.href = window.URL.createObjectURL(blob);
                        // link.download = 'archivo.pdf';
                        link.download = dataVenta.cabecera[0].VEN_TipoDocumento + "-" + dataVenta.cabecera[0].VEN_Serie;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);

                    },
                    error: function(xhr, status, error) {
                        alert('- Error al descargar el archivo');
                        console.log("Status: ", status);
                        console.log("Error: ", error);
                        console.log("XHR: ", xhr);
                    },
                    beforeSend: function() {
                        mostrarCargando('Procesando...');
                    },
                    complete: function() {
                        cerrarCangando();
                    }
                });

            },
            error: function(error) {
                alert('- Error al descargar ' + _Tipo);
                console.log(error);
            },
            beforeSend: function() {
                mostrarCargando('Procesando...');
            },
            complete: function() {
                cerrarCangando();
            }
        });
    }

    function btnDescargarArchivo(_Codigo, _Tipo) {

        $.ajax({
            type: "GET",
            url: RUTA_API + "PA_ObtenerArchivo_PorCodigo/" + _Codigo + "/" + _Tipo,
            dataType: "JSON",
            success: function(data) {
                console.log("btnDescargarArchivo => url:", RUTA_API + "PA_ObtenerArchivo_PorCodigo/" + _Codigo + "/" + _Tipo)

                if (data.rpta == 'ok') {
                    //console.log("btnDescargarArchivo => data:", data)
                    var link = document.createElement("a");
                    link.download = data.nombre;
                    link.href = data.uri;
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);
                    delete link;
                } else {
                    alert(data.ruta);
                }
            },
            error: function(error) {
                alert('- Error al descargar ' + _Tipo)
                console.log(error);
            },
            beforeSend: function() {
                mostrarCargando('Procesando...');
            },
            complete: function() {
                cerrarCangando();
            }
        });
    }

    async function mostrarCargando(msg) {
        $.blockUI({
            message: '<img src="../files/img/loader.gif" style="max-width: 80px;" /><p>' + msg + '</p>',
            overlayCSS: {
                backgroundColor: '#1b2024',
                opacity: 0.8,
                cursor: 'default',
                zIndex: 10000
            },
            css: {
                border: 0,
                color: '#fff',
                padding: 0,
                backgroundColor: 'transparent',
                cursor: 'default',
                zIndex: 10001
            }
        });
    }

    function cerrarCangando() {
        $.unblockUI();
    }

    //Búsqueda de clientes
    $('#txtCliente').autocomplete({
        source: function(request, response) {
            $.ajax({
                url: RUTA_API + 'ListarClientes',
                datatype: 'json',
                data: {
                    buscar: $('#txtCliente').val().trim()
                },
                success: function(data) {
                    $('#waiting').html('')
                    response(data.data)
                },
                error: function(error) {
                    $('#waiting').html('')
                    alert('Error al conectar a Bd del servidor...')
                }
            });
        },
        select: function(event, ui) {
            $('#idcliente').val(ui.item.codigo);
            $('#txtCliente').prop('readonly', true);
            $('#txtCliente').val(ui.item.label);
            document.forms['frmVentas'].submit()
            return false;
        }
    });

    $('#txtCliente').keydown(function(e) {
        if (e.which == 8 || e.which == 46) { //back o suprimir
            if ($('#idcliente').val() == '') {

            } else {
                limpiarProveedor();
            }
        }
    })

    $('#txtCliente').keyup(function(e) {
        if ($('#txtCliente').val().trim() == '') {
            $('#waiting').html('');
        } else {
            if (e.which == 37 || e.which == 38 || e.which == 39 || e.which == 40 || e.which == 13) {
                $('#waiting').html('');
            } else {
                var _valor = document.getElementById('txtCliente').readOnly;
                if (_valor == false) {
                    $('#waiting').html('<i class="spinner-border spinner-border-sm mr-2 text-green"></i>');
                } else {
                    $('#waiting').html('');
                }
            }
        }
    })

    function limpiarCliente() {
        $('#idcliente').val('0');
        $('#txtCliente').val('');
        $('#txtCliente').prop('readonly', false);
        $('#txtCliente').focus();
        document.forms['frmVentas'].submit()
    }
</script>

@endsection