@extends('index')
@section('estilos')
    <link rel="stylesheet" href="/files/calendario/css/bootstrap-datepicker.standalone.css?v={{ date('d-m-Y h:i:s') }}">
@endsection
@section('contenido')
    <div class="card" style="margin-top: -15px">
        <div class="card-header border shadow">
            <a href="{{ route('Reportes.index') }}"><i class="fas fa-arrow-left text-red"></i></a>
            <i class="fas fa-book text-green"></i>
            <font style="font-family:Cambria; font-size: 12pt; font-weight: bold">
                {{ $descripCaja }} <br>
            </font>
        </div>
        <div class="card-body border shadow">
            <form id="frmActualizar">
                <div class="row">
                    <div class="col-md-3 col-12">
                        <label for="">DESDE:</label>
                        <div class="input-group date form_date" data-date-format="dd/mm/yyyy" data-provide="datepicker">
                            <input readonly type="text" class="form-control" name="desde" id="desde"
                                data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy" data-mask=""
                                im-insert="false" value="{{ $desde }}" placeholder="dd/mm/yyyy">
                            <div class="input-group-btn">
                                <button class="btn btn-primary date-set" type="button">
                                    <i class="fa fa-calendar"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-12">
                        <label for="">HASTA:</label>
                        <div class="input-group date form_date" data-date-format="dd/mm/yyyy" data-provide="datepicker">
                            <input readonly type="text" class="form-control" name="hasta" id="hasta"
                                data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy"
                                data-mask="dd/mm/yyyy" im-insert="false" value="{{ $hasta }}"
                                placeholder="dd/mm/yyyy">
                            <div class="input-group-btn">
                                <button class="btn btn-primary date-set" type="button">
                                    <i class="fa fa-calendar"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label>CATEGORÍA:</label>
                        <select class="form-control" name="cat" id="cat">
                            <option value="TODOS">TODOS</option>
                            @foreach($categorias as $c => $item)
                                <option value="{{ $item['CAT_Codigo'] }}" {{ $item['CAT_Codigo'] == ($cat.'    ') ? 'selected':'' }} >{{ $item['CAT_Nombre'] }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2 col-12">
                        <label for="">&nbsp;</label>
                        <button type="submit" class=" form-control btn btn-primary">
                            <i class="fas fa-search"></i> Actualizar </button>
                    </div>
                </div>
            </form>
        </div>
        <div class="card-body border shadow">
            <div class="row">
                <div class="col-md-12">
                    <div class="row">
                        <div class="table-responsive" id="dvTabla" @if(count($datos)>15) style="height: 590px" @endif>
                            <table class="table table-bordered table-sm table-striped">
                                <thead class="bg-black" style="font-family: Cambria; font-size: 10pt">
                                    <tr>
                                        <th class="text-center">DESCRIPCIÓN</th>
                                        <th class="text-center">CATEGORÍA</th>
                                        <th class="text-right" style="width: 80pt">CANT.</th>
                                        <th class="text-right" style="width: 80pt">PRECIO</th>
                                        <th class="text-center" style="width: 50px">IMPORTE</th>
                                    </tr>
                                </thead>
                                <?php $n = 0; $total = 0; ?>
                                <tbody style="font-family: Cambria; font-size: 9pt">
                                    @foreach ($datos as $c => $item)
                                        <tr>
                                            <td>{{ $item['DV_Descripcion'] }}</td>
                                            <td>{{ $item['cat_nombre'] }}</td>
                                            <td class="text-right">{{ number_format($item['Cantidad'], 2, '.', '') }}</td>
                                            <td class="text-right">{{ number_format($item['Precio'], 2, '.', '') }}</td>
                                            <td class="text-right">{{ number_format($item['Importe'], 2, '.', '') }}</td>
                                        </tr>
                                        <?php $n += 1; $total += $item['Importe']; ?>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="row mt-2">
                        <div class="col-md-3 col-3">
                            <label for="" style="color: black; margin-left: -5px; font-size: 8pt">ITEMS: {{ $n }}</label>
                        </div>
                        <div class="col-md-3 d-none d-sm-block"></div>
                        <div class="col-md-4 col-4 text-right">
                            <label for="" style="color: blue; margin-top: 7px">TOTAL: S/. </label>
                        </div>
                        <div class="col-md-2 col-5">
                            <input type="text" class="text-center form-control" value="{{ number_format($total, 2, '.', '') }}" readonly>                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <br>
@endsection
@section('scripts')
    <script src="/files/calendario/js/bootstrap-datepicker.min.js?v={{ date('d-m-Y h:i:s') }}"></script>
    <script src="/files/calendario/locales/bootstrap-datepicker.es.min.js?v={{ date('d-m-Y h:i:s') }}"></script>
    <script>
        $(document).ready(function() {
            $('#desde').datepicker({
                orientation: "bottom"
            })
            
            $('#hasta').datepicker({
                orientation: "bottom"
            })
            
            var value = $("#nom").val();
            $("#nom").focus().val('').val(value);
        });

    </script>
@endsection
