<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Tienda Uriol</title>
    <link rel="icon" type="image/png" href="/files/img/icon/conf-128.svg" />
    
    <meta http-equiv="Expires" content="0">
    <meta http-equiv="Last-Modified" content="0">
    <meta http-equiv="Cache-Control" content="no-cache, mustrevalidate">
    <meta http-equiv="Pragma" content="no-cache">
    
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <link rel="stylesheet" href="/files/plantilla/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="/files/plantilla/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="/files/librerias/sweetAlert/sweetalert.css" media="screen" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="/files/newJS/datatables/jquery.dataTables.min.css">
    <link rel="stylesheet" href="/files/librerias/lightcase-2.5.0/src/css/lightcase.css">
    @yield('estilos')
</head>

<body class="sidebar-mini layout-fixed">
    <div class="wrapper">
        <nav class="main-header navbar navbar-expand navbar-dark bg-black">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('Pedido.index') }}"><i class="fas fa-home"></i>
                        <abbr class="d-none d-sm-block float-right" style="text-decoration: none">&nbsp;Inicio</abbr>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('logout') }}"><i class="fas fa-sign-out-alt"></i>
                        Salir</a>
                </li>
            </ul>
        </nav>
        
        <aside class="main-sidebar sidebar-dark-primary elevation-4" style="background-color: #035A85">
            <div class="brand-link">
                <img alt="AdminLTE Logo" class="brand-image img-circle elevation-3" src="/files/img/cargo.png"
                    style="opacity: .8">
                <span
                    class="brand-text font-weight-light">Tienda</span>
            </div>

            <div class="sidebar">
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <a href="{{ asset('/files/img/foto-user/male.jpg') }}" data-rel="lightcase" title="{{ $user['nombres'].' '.$user['apellidos'] }}">
                            <img class="img-circle elevation-2" alt="Foto de Perfil"
                                src="{{ asset('/files/img/foto-user/male.jpg') }}">
                        </a>
                    </div>
                    <div class="info">
                        <label for="" style="color: white">{{ $user['apellidos'] }} <i
                                class="fas fa-circle text-success"></i></label>
                    </div>
                </div>

                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
 

                        <li class="nav-header">CONSULTAS</li>
                        
                        <li class="nav-item has-treeview @if (session('pos')=='1' ) menu-open @endif">
                            <a href="#" class="nav-link @if (session('pos')=='1' ) active @endif">
                                <i class="nav-icon fas fa-chart-line"></i>
                                <p>
                                    Ventas
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="{{ route('Pedido.index') }}" class="nav-link @if (session('subitem')=='1.1' ) active @endif">
                                        <i class="nav-icon fa fa-dollar-sign"></i>                                        
                                        <p>Listar Ventas</p>
                                    </a>
                                </li> 
                            </ul>
                        </li>
                        
                        <li class="nav-item has-treeview @if (session('pos')=='3' ) menu-open @endif">
                            <a href="#" class="nav-link @if (session('pos')=='3' ) active @endif">
                                <i class="nav-icon fas fa-money-check-alt"></i>
                                <p>
                                    Caja
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="{{ route('Caja.VerIngresos') }}" class="nav-link @if (session('subitem')=='3.1' ) active @endif">
                                        <i class="nav-icon fa fa-dollar-sign"></i>                                        
                                        <p>Listar Ingresos</p>
                                    </a>
                                </li> 
                            </ul>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="{{ route('Caja.VerEgresos') }}" class="nav-link @if (session('subitem')=='3.2' ) active @endif">
                                        <i class="nav-icon fa fa-dollar-sign"></i>                                        
                                        <p>Listar Egresos</p>
                                    </a>
                                </li> 
                            </ul>
                        </li>
                        
                        <li class="nav-item has-treeview @if (session('pos')=='2' ) menu-open @endif">
                            <a href="#" class="nav-link @if (session('pos')=='2' ) active @endif">
                                <i class="nav-icon fas fa-truck"></i>
                                <p>
                                    Almacén
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="{{ route('Almacen.VerComidas') }}" class="nav-link @if (session('subitem')=='2.1' ) active @endif">
                                        <i class="nav-icon fa fa-tag"></i>                                        
                                        <p>Productos</p>
                                    </a>
                                </li> 
                            </ul>
                        </li>
                        
                        <li class="nav-header">CUENTA</li>
                        <li class="nav-item has-treeview">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-cog"></i>
                                <p>
                                    Configuración
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">                                
                                <li class="nav-item">
                                    <form action="{{ route('logout') }}" method="POST">
                                        @csrf
                                        <button type="submit" class="btn btn-block btn-outline-secondary btn-sm text-white">
                                            Cerrar Sesión
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </nav>
            </div>
        </aside>

        <div class="content-wrapper">
            <br>

            <section class="content">
                @yield('contenido')
            </section>
        </div>

        <footer class="main-footer">

        </footer>

        <aside class="control-sidebar control-sidebar-dark">
        </aside>
    </div>

    <script src="/files/plantilla/plugins/jquery/jquery.min.js"></script>
    <script src="/files/plantilla/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="/files/plantilla/dist/js/adminlte.min.js"></script>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
    <script src="/files/newJS/ruta-api.js?v={{ date('d-m-Y h:i:s') }}"></script>
    <script src="/files/newJS/datatables/jquery.dataTables.min.js"></script>
    <script src="/files/librerias/sweetAlert/sweetalert-dev.js?v={{ date('d-m-Y h:i:s') }}"></script>
    <script src="/files/librerias/ui/jquery.blockUI.js"></script>
    <script src="/files/librerias/lightcase-2.5.0/src/js/lightcase.js"></script>
    @yield('scripts')
</body>

</html>
