
<?php $__env->startSection('estilos'); ?>
    <link rel="stylesheet" href="/files/calendario/css/bootstrap-datepicker.standalone.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contenido'); ?>
    <div class="container-fluid">   
        <?php if(session('good')): ?>
            <div class="alert alert-success alert-dissmissible fade show" role="alert">
                <?php echo e(session('good')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dissmissible fade show" role="alert">
                <?php echo e(session('error')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>            
        <?php endif; ?>

        <form action="">
            <a id="link" href="" hidden></a>
            <div class="row" style="margin-top: -10pt">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" id="pnlAtencion">  
                    <div class="card">
                        <div class="card-header" >                                           
                            <i class="fas fa-dollar-sign text-red"></i>
                            <span class="letra">Egresos de Dinero</span>                                     
                        </div>
                        <div class="card-body border shadow">            
                            <div class="row" style="margin-top: -10px">
                                <div class="col-md-2 col-12">
                                    <label for="">Desde:</label>
                                    <div class="input-group date form_date" data-date-format="dd/mm/yyyy" data-provide="datepicker">
                                        <input readonly type="text" class="form-control" name="desde" id="desde"
                                            data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy" data-mask=""
                                            im-insert="false" value="<?php echo e($desde); ?>" placeholder="dd/mm/yyyy">
                                        <div class="input-group-btn">
                                            <button class="btn btn-primary date-set" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 col-12">
                                    <label for="">Hasta:</label>
                                    <div class="input-group date form_date" data-date-format="dd/mm/yyyy" data-provide="datepicker">
                                        <input readonly type="text" class="form-control" name="hasta" id="hasta"
                                            data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy"
                                            data-mask="dd/mm/yyyy" im-insert="false" value="<?php echo e($hasta); ?>"
                                            placeholder="dd/mm/yyyy">
                                        <div class="input-group-btn">
                                            <button class="btn btn-primary date-set" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6"></div>
                                <div class="col-md-2 col-12">
                                    <label for="" class="d-none d-sm-block">&nbsp;</label>
                                    <label for="" class="d-block d-sm-none"></label>
                                    <button type="submit" class=" form-control btn btn-primary">
                                        <i class="fas fa-search"></i> Filtrar </button>
                                </div>                                    
                            </div>    
                        </div>                                            
                        <div class="card-body border shadow">
                            <div class="row">
                                <div class="col-md-12">
                                    <span class="d-block d-sm-none" style="font-size: 10pt">
                                        Deslizar tabla a la der/izq para más detalles.
                                    </span>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <thead class="bg-secondary" style="font-size: 10pt">
                                                <tr>                                                        
                                                    <th style="width: 130pt">Fecha&nbsp;de&nbsp;Emisión&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
                                                    <th>Nº&nbsp;Ingreso</th>
                                                    <th>Tipo&nbsp;Salida</th>
                                                    <th>Observaciones&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>                                            
                                                    <th class="text-right">Total</th>
                                                </tr>
                                            </thead>
                                            <tbody style="font: Arial; font-size: 10pt;">                                    
                                                <?php $__currentLoopData = $ventas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>                                                                                            
                                                        <td><?php echo e($item['SAL_FechaSalida']); ?></td>                                                        
                                                        <td><?php echo e($item['SAL_Nro']); ?></td>
                                                        <td><?php echo e($item['TO_Descripcion']); ?></td>                                                
                                                        <td><?php echo e($item['SAL_Concepto']); ?></td>
                                                        <td class="text-right"><?php echo e(number_format($item['SAL_Total'], 2)); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="row">   
                                        <div class="col-md-2 col-6 text-center" style="padding-top: 7px">
                                        </div>
                                        <div class="col-md-2 col-6">
                                            <input hidden type="text" class="form-control text-center text-bold" style="font-size: 12pt" readonly="readonly" value="<?php echo e(number_format($contado, 2)); ?>">
                                        </div>                                 
                                        <div class="col-md-2 col-6 text-center" style="padding-top: 7px">
                                        </div>
                                        <div class="col-md-2 col-6">
                                            <input hidden type="text" class="form-control text-center text-bold" style="font-size: 12pt" readonly="readonly" value="<?php echo e(number_format($credito, 2)); ?>">
                                        </div>                                    
                                        <div class="col-md-2 col-6 text-center" style="padding-top: 7px">
                                            <label for="">Total: s/.</label>
                                        </div>
                                        <div class="col-md-2 col-6">
                                            <input type="text" class="form-control text-center text-bold" style="font-size: 12pt" readonly="readonly" value="<?php echo e(number_format($total, 2)); ?>">
                                        </div>
                                    </div>                                               
                                </div>
                            </div>
                        </div>
                    </div>
                </div>                            
            </div>          
        </form>  
    </div> 
    <?php echo $__env->make('Ventas.modalVerDetalle', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>  
    <script src="/files/calendario/js/bootstrap-datepicker.min.js"></script>
    <script src="/files/calendario/locales/bootstrap-datepicker.es.min.js"></script>
    
    <script>
        function btnVerDocVenta(_Codigo, _NroDoc) {
            $('#nrodoc').html(_NroDoc);
            $('#tblbodyDetalles').html('');
            $('#modalVerDetalle').modal('show');            
            
            $.ajax({
                type: "GET",
                url: RUTA_API + "PA_ObtenerDetallesVenta_PorCodigo/" + _Codigo,
                dataType: "JSON",
                success: function(data) {     
                    console.log(data);
                    
                    var x = 1;
                    var totalCosto = 0;
                    var totalVenta = 0;
                    data.detalles.forEach(element => {                            
                        
                        var fila = construirFilaDetalle(x, element.DVEN_Descripcion, parseFloat(element.DVEN_Cantidad), 
                        element.DVEN_Unidad, parseFloat(element.DVEN_PrecioVenta).toFixed(2), element.DVEN_Importe);                            
                        $('#tblDetalleVentas').append(fila);                                    
                        
                        totalCosto += parseFloat(element.DVEN_Cantidad) * parseFloat(element.DVEN_PrecioCosto);
                        totalVenta += parseFloat(element.DVEN_Importe);
                        x++;
                    });

                    $('#totalDetalleVenta').val(totalVenta.toFixed(2));
                    $('#totalDetalleCosto').val(totalCosto.toFixed(2));
                    $('#totalDetalleGanancia').val((totalVenta - totalCosto).toFixed(2));
                },
                error: function(error) {
                    alert('- Error al obtener detalle de venta')
                    console.log(error);
                },
            });

        }

        function construirFilaDetalle(item, nombre, cantidad, unidad, venta, importeventa){
            var contenido = '<tr>';            
            contenido += '<td style="width: 40pt" class="text-center">'+cantidad+'</td>';
            contenido += '<td style="width: 40pt" class="text-center">'+unidad+'</td>';            
            contenido += '<td> '+nombre+'</td>';            
            contenido += '<td style="width: 50pt" class="text-right">'+venta+'</td>';
            contenido += '<td style="width: 50pt" class="text-right">'+parseFloat(importeventa).toFixed(2)+'</td>';
            contenido += '</tr>';
            return contenido;
        }
        
        function btnDescargarArchivo(_Codigo, _Tipo){
            
            $.ajax({
                type: "GET",
                url: RUTA_API + "PA_ObtenerArchivo_PorCodigo/" + _Codigo + "/" + _Tipo,
                dataType: "JSON",
                success: function(data) {     
                    if (data.rpta == 'ok'){
                        var link = document.getElementById('link');
                        link.href = data.ruta;
                        link.download = data.nombre;
                        link.click();
                    }
                    else{
                        alert(data.ruta);
                    }
                },
                error: function(error) {
                    alert('- Error al descargar '+_Tipo)
                    console.log(error);
                },
                beforeSend: function() {
                    mostrarCargando('Procesando...');
                },
                complete: function() {
                    cerrarCangando();
                }
            });
        }
        
        function mostrarCargando(msg) {
            $.blockUI({
                message: '<img src="../files/img/loader.gif" style="max-width: 80px;" /><p>' + msg + '</p>',
                overlayCSS: {
                    backgroundColor: '#1b2024',
                    opacity: 0.8,
                    cursor: 'default'
                },
                css: {
                    border: 0,
                    color: '#fff',
                    padding: 0,
                    backgroundColor: 'transparent',
                    cursor: 'default'
                }
            });
        }
        
        function cerrarCangando() {
            $.unblockUI();
        }
        
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jflasolucion/SistemaUriol/resources/views/Caja/Egresos.blade.php ENDPATH**/ ?>