<?php $__env->startSection('contenido'); ?>
    <div class="container-fluid">
        <?php if(session('good')): ?>
            <div class="alert alert-success alert-dissmissible fade show" role="alert">
                <?php echo e(session('good')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <form id="frmProd">
            <div class="row" style="margin-top: -10pt">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" id="pnlAtencion">
                    <div class="card">
                        <div class="card-header">
                            <i class="fas fa-tag text-info"></i>
                            <span class="letra">Lista de Productos</span>
                        </div>
                        <div class="card-body border shadow">
                            <div class="row" style="margin-top: -10px">
                                <div class="col-sm-11 col-8">
                                    <label for="">Producto:</label>
                                    <input name="buscarpor" id="buscarpor" class="form-control" type="search"
                                           placeholder="Buscar por nombre"
                                           value="<?php echo e($buscarpor); ?>">
                                </div>
                                <div class="col-sm-1 col-4">
                                    <label for="">&nbsp;</label>
                                    <button class="btn btn-sm btn-primary form-control" type="submit"><i
                                            class="fas fa-search"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body border shadow">
                            <span class="d-block d-sm-none" style="font-size: 10pt">
                                Deslizar tabla a la der/izq para más detalles.
                            </span>
                            <div class="table-responsive">
                                <table class="table">
                                    <thead class="bg-secondary" style="font-size: 10pt">
                                    <tr>
                                        <th style="width: 60pt">Código</th>
                                        <th>Nombre&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>
                                        <th style="width: 50pt" class="text-center">Stock</th>
                                        <th style="width: 60pt">Medida</th>
                                        <th class="text-center" style="width: 50pt">Costo&nbsp;Prom.&nbsp;/&nbsp;Últ.&nbsp;Costo</th>
                                        <th class="text-center" style="width: 50pt">P.&nbsp;Público&nbsp;/&nbsp;Mínimo
                                        </th>
                                        <th class="text-center" style="width: 50pt">Acción</th>
                                    </tr>
                                    </thead>
                                    <tbody style="font: Arial; font-size: 10pt;" id="tblBodyProductos">
                                    <?php $__currentLoopData = $articulos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><a href="https://www.google.com/search?q=<?php echo e($item['pro_codigo']); ?>"
                                                   target="_blank"><?php echo e($item['pro_codigo']); ?></a></td>
                                            
                                            <td>
                                                <a href="javascript:;" onclick="clickFoto('<?php echo e($item['pro_id']); ?>')">
                                                     <?php echo e($item['pro_descripcion']); ?>

                                                </a>
                                            </td>
                                            
                                            <?php if($item['Stock'] <= 0): ?>
                                                <td style="width: 50pt" class="text-center text-red">
                                                    <strong><?php echo e($item['Stock']); ?></strong></td>
                                            <?php else: ?>
                                                <td style="width: 50pt" class="text-center">
                                                    <strong><?php echo e($item['Stock']); ?></strong></td>
                                            <?php endif; ?>

                                            <td style="width: 60pt"><?php echo e($item['pro_observacion']); ?></td>
                                            <td class="text-center"
                                                style="width: 50pt"><?php echo e(number_format($item['PRO_CostoPromedio'], 3).' / '.number_format($item['PRO_PrecioCosto'], 3)); ?></td>
                                            <td class="text-center"
                                                style="width: 50pt"><?php echo e(number_format($item['pro_precio_venta'], 3).' / '.number_format($item['PRO_Precio2'], 3)); ?></td>
                                            <td class="text-center">
                                                <div class="btn-group">
                                                    <button type="button" class="btn btn-info btn-sm dropdown-toggle"
                                                            data-toggle="dropdown" data-boundary="window"
                                                            aria-haspopup="true" aria-expanded="false">
                                                        <i class="fas fa-tasks"></i>
                                                    </button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="javascript:;"
                                                           onclick="btnShowDetail('<?php echo e($item['pro_id']); ?>')">
                                                            <i class="fas fa-list text-primary"></i> Ver Detalle
                                                        </a>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <?php echo $__env->make('Almacen.modalVerDetalle', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('Almacen.modalVerFotos', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        function clickFoto(id){
            //hacer peticion obteniendo cadenas
            
            $.ajax({
                type: "GET",
                url: RUTA_API + "PA_ObtenerFotoProducto_PorID/" + id,
                dataType: "JSON",
                success: function (data) {
                    // Asignar valores a las propiedades específicas usando product.prop
                    $('#img1').attr('src', data.img1);
                    $('#img2').attr('src', data.img2);
                    $('#img3').attr('src', data.img3);
                    $('#img4').attr('src', data.img4);
                    $('#modalVerFotos').modal('show');
                },
                error: function (error) {
                    alert('- Error al obtener detalle de venta')
                    console.log(error);
                },
                beforeSend: function () {
                    mostrarCargando('Procesando...');
                },
                complete: function () {
                    cerrarCangando();
                }
            });
        }
    
        function btnShowDetail(productId) {
            // $('#nrodoc').html(_NroDoc);
            // $('#tblbodyDetalles').html('');

            $.ajax({
                type: "GET",
                url: RUTA_API + "PA_ObtenerProducto_PorID/" + productId,
                dataType: "JSON",
                success: function (data) {
                    let product = null;
                    if(data.length > 0){
                        product = data[0]
                    }
                    // Asignar valores a las propiedades específicas usando product.prop
                    $('#PRO_CostoPromedio').val(parseFloat(product.PRO_CostoPromedio).toFixed(3));
                    $('#PRO_Precio2').val(parseFloat(product.PRO_Precio2).toFixed(3));
                    $('#PRO_PrecioCosto').val(parseFloat(product.PRO_PrecioCosto).toFixed(3));
                    $('#Stock').val(product.Stock);
                    $('#cat_nombre').val(product.cat_nombre);
                    $('#mar_nombre').val(product.mar_nombre);
                    $('#pro_codigo').val(product.pro_codigo);
                    $('#pro_descripcion').val(product.pro_descripcion);
                    $('#pro_id').val(product.pro_id);
                    $('#pro_observacion').val(product.pro_observacion);
                    $('#pro_precio_venta').val(parseFloat(product.pro_precio_venta).toFixed(3));
                    $('#sca_nombre').val(product.sca_nombre);
                    $('#ume_descripcion').val(product.ume_descripcion);
                    $('#modalVerDetalle').modal('show');
                },
                error: function (error) {
                    alert('- Error al obtener detalle de venta')
                    console.log(error);
                },
                beforeSend: function () {
                    mostrarCargando('Procesando...');
                },
                complete: function () {
                    cerrarCangando();
                }
            });
        }

        function mostrarCargando(msg) {
            $.blockUI({
                message: '<img src="../files/img/loader.gif" style="max-width: 80px;" /><p>' + msg + '</p>',
                overlayCSS: {
                    backgroundColor: '#1b2024',
                    opacity: 0.8,
                    cursor: 'default'
                },
                css: {
                    border: 0,
                    color: '#fff',
                    padding: 0,
                    backgroundColor: 'transparent',
                    cursor: 'default'
                }
            });
        }

        function cerrarCangando() {
            $.unblockUI();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jflasolucion/public_html/uriolchepen.jflasolucion.com/Sistema/resources/views/Almacen/VerComidas.blade.php ENDPATH**/ ?>