const express = require('express');
const { createServer } = require('http');
const WebSocket = require('ws')

const app = express();
const server = createServer(app);
const ws = new WebSocket.Server({ server });

var clientes = []
var i = 0

ws.on('connection', function(ws) {

    var id = formatoCadena(i)
    ws.send('I' + id);
    clientes.push({ id: id, socket: ws, estado: 'Habilitado' })

    ws.on('message', function(data) {
        console.log(data);

        var datos = data.toString();
        var accion = datos.substr(0, 1);
        var id = datos.substr(1, 9);
        var mensaje = datos.substr(10, datos.length - 10);

        if (accion == 'A') {
            clientes.forEach(element => {
                if (element.estado == 'Habilitado' && element.id != id) {
                    element.socket.send(datos);
                }
            });
        } else if (accion == 'T') {
            console.log('Listar Todos [SOLICITANTE: ' + id + ']')
            var contactos = ''
            var x = 0;
            clientes.forEach(element => {
                if (element.estado == 'Habilitado') {
                    if (x == 0) contactos = element.id
                    else contactos += '|' + element.id
                    x++;
                }
            });
            ws.send('T' + id + contactos)
        } else {
            // clientes.forEach(element => {
            //     // if (element.estado == 'Habilitado' && element.id != id) {
            //     //     element.socket.send(data)
            //     // }
            //     if (element.estado == 'Habilitado') {
            //         element.socket.send(data)
            //     }
            // });
        }
    });

    ws.on('close', function() {
        console.log('Solicitud de desconexión')
        var idSocketEliminado = null
        clientes.forEach(element => {
            if (element.socket == ws) {
                idSocketEliminado = element.id
                element.estado = 'Eliminado'
            }
        });

        console.log('conexión finalizada de cliente [' + idSocketEliminado + ']');
    });

    i++

    console.log('usuario [' + id + ', CONECTADO]');
});

server.listen(3000, function() {
    // console.log('Servidor iniciado en http://localhost:3000');
    console.log('Servidor iniciado en http://192.168.43.34:3000');
});

function formatoCadena(numero) {
    if (numero < 10) return '00000000' + numero
    else if (numero < 100) return '0000000' + numero
    else if (numero < 1000) return '000000' + numero
    else if (numero < 10000) return '00000' + numero
    else if (numero < 100000) return '0000' + numero
    else if (numero < 1000000) return '000' + numero
    else if (numero < 10000000) return '00' + numero
    else if (numero < 100000000) return '0' + numero
    else return numero
}