// var estaprogramado = filaSeleccionada.attr('estaprogramado')

var _PisoSeleccionado = '';
var _CodPisoSeleccionado = ''

$(document).ready(function(e) {
    Piso_Click(zona1_Des, zona1_Cod);

    $('#modalComentario').on('shown.bs.modal', function(e) {
        $('#txtComentario').focus()
    })

    $('#txtComentario').keypress(function(e) {
        if (e.which == 13) {
            $('#OkComentario').focus()
        }
    })
})

_htmlSeleccioneMesa = '<div class="card card-primary"> ' +
    '<div class="card-body"> ' +
    '<div class="row pt-5"> ' +
    '<div class="col-md-12"></div> ' +
    '<div class="col-md-12"> ' +
    '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 11pt"> ' +
    '← Selecciona una Mesa ' +
    '</span> ' +
    '</div> ' +
    '<div class="col-md-12 pt-5"></div> ' +
    '</div> ' +
    '</div> ' +
    '</div>'

function Piso_Click(piso, codPiso) {
    _PisoSeleccionado = piso;
    _CodPisoSeleccionado = codPiso;

    for(var i=0;i<zonitas.length;i++)
    {
        $('#'+zonitas[i].ZM_Codigo).html('<i class="spinner-border spinner-border-sm mr-2 text-green"></i> Cargando...')
    }

    $.ajax({
        type: 'GET',
        url: RUTA_API + 'ListarMesasPorUbicacion/' + piso,
        dataType: 'JSON',
        success: function(data) {
            var contenido = '<div class="row" style="margin-top: -10pt"> '

            var _codMESA = '';
            var _numMESA = '';
            var _estMESA = '';

            data.forEach(element => {
                contenido += '<div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-2 pt-2"> ' +
                    '<input id="'+element.MES_Codigo.trim()+'" type="text" value="'+element.CodPedido+'" hidden><button codPer="'+element.CodPedido+'" class="btn ' + ColorMesa(element.MES_EstadoMesa) + '"' +
                    'estado="' + element.MES_EstadoMesa + '" ' +
                    'onclick="Mesa_Click(' + "'" + element.MES_Codigo + "'" + ', ' + "'" + element.MES_Numero + "'" + ', ' + "'" + element.MES_EstadoMesa + "'" + ')"> ';
                    
                if (element.CodPedido == PER_Codigo){
                    contenido += ' <font style="font-size: 14pt; color: white"><em><u>' + element.MES_Numero + '</em></u></font> ';
                }
                else{
                    contenido += ' <font style="font-size: 14pt; color: white">' + element.MES_Numero + '</font> ';
                }
                
                contenido += '</button> ' +
                    '</div> '

                if (MES_Codigo == MES_CodigoSocket && element.MES_Codigo == MES_CodigoSocket) {
                    _codMESA = element.MES_Codigo;
                    _numMESA = element.MES_Numero;
                    _estMESA = element.MES_EstadoMesa;
                }
            });

            contenido += '</div>'

            for(var i=0;i<zonitas.length;i++)
            {
                $('#'+zonitas[i].ZM_Codigo).removeClass('active show')
            }
             
            $('#'+codPiso).addClass('active show')
            $('#'+codPiso).html(contenido)
            
            if (_codMESA != '') {
                Mesa_Click(_codMESA, _numMESA, _estMESA);
            }
        },
        error: function(error) {
            console.log(error)
        },
        beforeSend: function() {
            mostrarCargando('Obteniendo datos...');
        },
        complete: function() {
            cerrarCangando();
        }
    })
}

function ColorMesa(estado) {
    if (estado === 'DISPONIBLE') return 'bg-blue';
    else if (estado === 'OCUPADO') return 'bg-red';
    else if (estado === 'RESERVADO') return 'bg-pink';
    else return 'btn-secondary';
}

var Pedido = new Object()
var xDetallesPedidoActual = []
var xDetallesPedidoNuevos = []
var MES_Codigo, MES_Numero, MES_EstadoMesa, MES_CodigoSocket

function Mesa_Click(MES_Codigo, MES_Numero, MES_EstadoMesa, Aux) {
    
    var codig = $('#'+MES_Codigo.trim()).val();
    if (Aux == 'Abriendo') codig = PER_Codigo;
    if (codig == 'null'){
        
    }
    else{
     if (codig != PER_Codigo){
            swal({
                title: 'Advertencia!',
                text: 'LA MESA NO HA SIDO APERTURADA POR USTED.',
                timer: 2500
            })
            return
        }   
    }
    
    this.MES_Codigo = MES_Codigo
    this.MES_Numero = MES_Numero
    this.MES_EstadoMesa = MES_EstadoMesa

    if (MES_EstadoMesa == 'MANTENIMIENTO') {
        swal({
            title: 'Advertencia!',
            text: 'MESA ' + MES_Numero + ' SE ENCUENTRA EN MANTENIMIENTO',
            timer: 2500
        })
        return
    }

    // $('#pnlAtencion').html(_divPrincipalAtencion)
    // $('#pnlContenidoAtencion').html(_htmlClientePedido);
    // $('#pnlBodyClientePedido').html(_htmlBodyClientePedido);

    $('#pnlAtencion').html(_htmlClientePedido)
    $('#pnlBodyClientePedido').html(_htmlBodyClientePedido);

    $('#divPrincipalAtencion').removeClass('card-primary card-danger card-pink')
    if (MES_EstadoMesa == 'OCUPADO') {
        $('#divPrincipalAtencion').html($('#divPrincipalAtencion').html() + ' ' + _htmlControlesFooter)
        $('#divPrincipalAtencion').addClass('card-danger')
        $('#tabCliente').removeClass('active show')
        $('#tabClientePestaña').removeClass('active')
        $('#tabPedido').removeClass('active show')
        $('#tabPedidoPestaña').removeClass('active')

        $('#tabPedido').addClass('active show')
        $('#tabPedidoPestaña').addClass('active')
        $('#tabPedido').html('<i class="spinner-border spinner-border-sm mr-2 text-green"></i> Cargando...')

        $('#btnActualizarPedido').prop('disabled', true)
        $('#tituloMesa').html('MESA: ' + MES_Numero + ' ...')
        clickTabPedido()

    } else {
        // if (MES_EstadoMesa == 'RESERVADO') {
        //     $('#tituloMesa').html('MESA: ' + MES_Numero + ' [RESERVADA]')
        //     $('#divPrincipalAtencion').addClass('card-pink')
        // } else {
        //     $('#tituloMesa').html('MESA: ' + MES_Numero)
        //     $('#divPrincipalAtencion').addClass('card-primary')
        // }

        clickTabCliente();
        $('#tabCliente').addClass('active show')
        $('#tabClientePestaña').addClass('active')

        $('#btnAbrir').html('<i class="fas fa-unlock"></i> Abrir Mesa ' + MES_Numero)
        if (MES_EstadoMesa == 'RESERVADO') {
            $('#btnAbrir').addClass('bg-pink')
        } else {
            $('#btnAbrir').addClass('btn-primary')
        }

        $('#txtcliente').focus()
    }
}

// var _divPrincipalAtencion = '<div class="card card-primary" id="divPrincipalAtencion">  <div class="card-header"> <span class="card-title" id="tituloMesa" style="font-family:  Arial, Helvetica, sans-serif; font-size: 11pt">MESA 0</span> </div> <div class="card-body" id="pnlContenidoAtencion"> </div> </div>';
// var _htmlClientePedido = '<div class="card card-secondary card-tabs" style="margin-top: -5pt; margin-left: -5pt"> <div class="card-header p-0"> <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist"> <li class="nav-item" onclick="clickTabCliente()"> <a class="nav-link active btn-sm" id="tabClientePestaña" data-toggle="pill" href="javascript:;" role="tab" aria-controls="custom-tabs-one-home" aria-selected="true">Cliente</a> </li> <li class="nav-item" onclick="clickTabPedido()"> <a class="nav-link btn-sm" id="tabPedidoPestaña" data-toggle="pill" href="javascript:;" role="tab" aria-controls="custom-tabs-one-profile" aria-selected="false">Pedido</a> </li> </ul> </div> <div class="card-body" id="pnlBodyClientePedido"> </div> </div>'
var _htmlClientePedido = '<div class="card card-secondary card-tabs"> <div class="card-header p-0"> <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist"> <li class="nav-item" onclick="clickTabCliente()"> <a class="nav-link active btn-sm" id="tabClientePestaña" data-toggle="pill" href="javascript:;" role="tab" aria-controls="custom-tabs-one-home" aria-selected="true">Cliente</a> </li> <li class="nav-item" onclick="clickTabPedido()"> <a class="nav-link btn-sm" id="tabPedidoPestaña" data-toggle="pill" href="javascript:;" role="tab" aria-controls="custom-tabs-one-profile" aria-selected="false">Pedido</a> </li> </ul> </div> <div class="card-body" id="pnlBodyClientePedido"> </div> </div>'
var _htmlBodyClientePedido = '<div class="tab-content" id="custom-tabs-one-tabContent"> <div class="tab-pane fade active show" id="tabCliente" role="tabpanel" aria-labelledby="custom-tabs-one-home-tab"> </div> <div class="tab-pane fade" id="tabPedido" role="tabpanel" aria-labelledby="custom-tabs-one-profile-tab"> </div> </div>'
var _htmlControlesFooter = '<div class="card-footer" style="background-color: gainsboro"> <div class="row"> <div class="col-md-9"></div> <div class="col-md-3"> <button id="btnActualizarPedido" class="btn btn-sm btn-primary form-control" onclick="btnActualizarPedido()"> <i class="fas fa-edit"></i> Actualizar </button> </div> </div> </div>'

function clickTabCliente() {
    $('#tabCliente').html('<i class="spinner-border spinner-border-sm mr-2 text-green"></i> Cargando...')
    if (MES_EstadoMesa == 'OCUPADO') {
        $('#tabCliente').addClass('active show')
        $('#tabPedido').removeClass('active show')        

        $.ajax({
            type: 'GET',
            url: RUTA_API + 'ListarPedidoxCodigoMesa/' + MES_Codigo,
            dataType: 'JSON',
            success: function(data) {
                var xPedido = data.pedido
                var tam = xPedido.length;
                if (tam > 0) {
                    var contenido = htmlCliente_MesaOcupada()
                    $('#tabCliente').html(contenido)
                    
                    //$('#txtcliente').val(xPedido[0].PED_Cliente)
                    //$('#txtmesero').val(xPedido[0].PED_Mesero)
                    //$('#txtobservaciones').val(xPedido[0].PED_Observaciones)
                    
                    var cliArray = String(xPedido[0].PED_Cliente).split("|");
                    
                    if (cliArray.length > 2){
                        var _cli = String(cliArray[0]).trim();
                        var _dir = String(cliArray[2]).trim();
                        var _cel = String(cliArray[1]).trim();
                        
                        $('#txtcliente').val(_cli)
                        $('#txtdireccionCliente').val(_dir)
                        $('#txtcelularCliente').val(_cel)    
                    }
                    else
                    {
                        $('#txtcliente').val("")
                        $('#txtdireccionCliente').val("")
                        $('#txtcelularCliente').val("")    
                    }
                    if (xPedido[0].PED_Observaciones == ""){
                        xPedido[0].PED_Observaciones = " "
                    }
                    $('#txtobservaciones').val(xPedido[0].PED_Observaciones)
                    
                    //$('#txtcliente').prop('disabled', true)
                    //$('#txtdireccionCliente').prop('disabled', true)
                    //$('#txtcelularCliente').prop('disabled', true)
                    //$('#txtobservaciones').prop('disabled', true)
                }
            },
            error: function(error) {
                console.log(error)
            },
            beforeSend: function() {
                mostrarCargando('Obteniendo datos...');
            },
            complete: function() {
                cerrarCangando();
            }
        })
    } else {
        var contenido = htmlCliente_MesaLibre()
        $('#tabCliente').html(contenido)
        $('#txtcliente').val('')
        $('#txtmesero').val(meserito)
        $('#txtobservaciones').val('')
    }
}

function htmlCliente_MesaLibre() {
    var contenido = '<div class="row">' +
        '<div class="col-md-12" '+(VerDatos=="SI"?"":"hidden")+'> ' +
        '<label for="">NOMBRE:</label> ' +
        '<input type="text" name="txtcliente" id="txtcliente" placeholder="Ingrese nombre de cliente" class="form-control"> ' +
        '</div> ' +
        
        '<div class="col-md-12" '+(VerDatos=="SI"?"":"hidden")+'> ' +
        '<label for="">DIRECCIÓN:</label> ' +
        '<input type="text" name="txtdireccionCliente" id="txtdireccionCliente" placeholder="Ingrese dirección" class="form-control"> ' +
        '</div> ' +
        
        '<div class="col-md-12" '+(VerDatos=="SI"?"":"hidden")+'> ' +
        '<label for="">CELULAR:</label> ' +
        '<input type="text" name="txtcelularCliente" id="txtcelularCliente" placeholder="Ingrese celular" class="form-control"> ' +
        '</div> ' +

        // '<div class="col-md-12"> ' +
        // '<label for="">MESERO:</label> ' +
        // '<input type="text" name="txtmesero" id="txtmesero" class="form-control" readonly> ' +
        // '</div> ' +

        '<div class="col-md-12" '+(VerDatos=="SI"?"":"hidden")+'> ' +
        '<label for="">'+((_PisoSeleccionado == "DELIVERY")?"REFERENCIA:":"OBSERVACIONES:")+'</label> ' +
        '<textarea name="txtobservaciones" id="txtobservaciones" cols="30" rows="3" placeholder="Ingrese '+((_PisoSeleccionado == "DELIVERY")?"referencia":"observaciones")+'" class="form-control"></textarea> ' +
        '</div> ' +

        '<div class="col-md-12 mt-2"> ' +
        '<button class="btn btn-info form-control" onclick="Abrir_Mesa()" id="btnAbrir"><i class="fas fa-unlock"></i> Abrir mesa</button>' +
        '</div> ' +

        '</div>'
    return contenido
}

function htmlCliente_MesaOcupada() {
    var contenido = '<div class="row">' +
        '<div class="col-md-12"> ' +
        '<label for="">CLIENTE:</label> ' +
        '<input type="text" name="txtcliente" id="txtcliente" placeholder="Ingrese descripción de cliente" class="form-control" '+(VerDatos=="SI"?"":"readonly")+'> ' +
        '</div> ' +
        
        '<div class="col-md-12"> ' +
        '<label for="">DIRECCIÓN:</label> ' +
        '<input type="text" name="txtdireccionCliente" id="txtdireccionCliente" placeholder="Ingrese dirección" class="form-control" '+(VerDatos=="SI"?"":"readonly")+'> ' +
        '</div> ' +
        
        '<div class="col-md-12"> ' +
        '<label for="">CELULAR:</label> ' +
        '<input type="text" name="txtcelularCliente" id="txtcelularCliente" placeholder="Ingrese celular" class="form-control" '+(VerDatos=="SI"?"":"readonly")+'> ' +
        '</div> ' +

        // '<div class="col-md-12"> ' +
        // '<label for="">MESERO:</label> ' +
        // '<input type="text" name="txtmesero" id="txtmesero" class="form-control" readonly> ' +
        // '</div> ' +

        '<div class="col-md-12"> ' +
        '<label for="">'+((_PisoSeleccionado == "DELIVERY")?"REFERENCIA:":"OBSERVACIONES:")+'</label> ' +
        '<textarea name="txtobservaciones" id="txtobservaciones" cols="30" rows="3" placeholder="Ingrese '+((_PisoSeleccionado == "DELIVERY")?"referencia":"observaciones")+'" class="form-control" '+(VerDatos=="SI"?"":"readonly")+'></textarea> ' +
        '</div> ' +
        
        '<div class="col-md-12"> ' +
        
        '<div class="row pt-2" '+(VerDatos=="SI"?"":"hidden")+'> ' +
        '<div class="col-md-10 d-none d-sm-block"> </div> ' +
        '<div class="col-md-2 col-4 text-md-right text-right"> ' +
        '<button class="btn btn-sm btn-primary" id="btnSoloCliente" onclick="SoloCliente()"> ' +
        //'<i class="fas fa-bolt"></i> ' +
        'Guardar ' +
        '</button>' +
        '</div> ' +
        '</div> ' +
        
        '</div> ' +
        
        '</div>'
    return contenido
}

function SoloCliente(){
    
    if (confirm('¿Desea actualizar los datos?') == false){
        return;
    }
    
    var _cli = String($('#txtcliente').val()).trim();
    var _dir = String($('#txtdireccionCliente').val()).trim();
    var _cel = String($('#txtcelularCliente').val()).trim();
    
    var _cliente = _cli+" | "+_cel+" | "+_dir;
    var _observaciones = String($('#txtobservaciones').val()).trim();
    
    $.ajax({
        type: 'POST',
        url: RUTA_API + 'SoloCliente/'+Pedido.PED_Codigo,
        dataType: 'JSON',
        data: {
            cliente: _cliente,
            observaciones: _observaciones,
        },
        success: function(data) {
             //console.log(data)
             alert('Datos actualizados');
        },
        error: function(error) {
            console.log(error)
        },
        beforeSend: function() {
            mostrarCargando('Obteniendo datos...');
        },
        complete: function() {
            cerrarCangando();
        }
    })
}

function clickTabPedido() {
    filaSeleccionada = ''
    $('#tabPedido').html('<i class="spinner-border spinner-border-sm mr-2 text-green"></i> Cargando...')
    $('#btnActualizarPedido').prop('disabled', true)
    if (MES_EstadoMesa == 'OCUPADO') {

        $('#tabPedido').addClass('active show')
        $('#tabCliente').removeClass('active show')
        $('#tabPedidoPestaña').html('Pedido ' + MES_Numero)
        
        Pedido = new Object();
        xDetallesPedidoActual = []

        $.ajax({
            type: 'GET',
            url: RUTA_API + 'ListarPedidoxCodigoMesa/' + MES_Codigo,
            dataType: 'JSON',
            success: function(data) {
                // console.log(data)
                var xPedido = data.pedido
                xDetallesPedidoActual = data.detalles

                var tam = xPedido.length;
                if (tam > 0) {
                    //Cabecera
                    var mozo = xPedido[0].PED_Mesero
                    $('#tituloMesa').html('MESA: ' + MES_Numero + ' [MOZO: ' + mozo + ']')
                    Pedido.PED_Codigo = xPedido[0].PED_Codigo
                    Pedido.PED_Total = xPedido[0].PED_Total
                    Pedido.PED_Cliente = xPedido[0].PED_Cliente
                    Pedido.PED_Mesero = xPedido[0].PED_Mesero
                    Pedido.PED_Observaciones = xPedido[0].PED_Observaciones

                    //Detalles
                    var encabezado = htmlEncabezadoPedido(Pedido.PED_Codigo)
                    $('#tabPedido').html(encabezado)
                    htmlDetallesPedido(xDetallesPedidoActual)

                    $("#tblPedido tr").click(function() {
                        $(this).addClass('selected').siblings().removeClass('selected');
                        filaSeleccionada = $(this)
                    });

                    $('#btnActualizarPedido').prop('disabled', false)
                }
                else{
                    swal({
                        title: 'Refrescar Zona de Mesas',
                        text: 'La mesa ya no está ocupada.',
                        timer: 5000
                    })
                    $('#tabPedido').html('');
                    return
                }
            },
            error: function(error) {
                console.log(error)
            },
            beforeSend: function() {
                mostrarCargando('Obteniendo datos...');
            },
            complete: function() {
                cerrarCangando();
            }
        })
    } else {
        swal({
            title: 'ADVERTENCIA',
            text: 'DEBE ABRIR MESA.\nEl mensaje se cerrará en 3 seg...',
            timer: 3000
        })
        Mesa_Click(MES_Codigo, MES_Numero, MES_EstadoMesa)
    }
}
var filaSeleccionada = ''

//*****************************************************************ENCABEZADO PEDIDO
function htmlEncabezadoPedido(codPed) {
    console.log()
    var contenido =
        '<div class="row">' +
       '<div class="col-md-3 col-6"> ' +
        '<button class="form-control btn btn-sm btn-info" id="buscarComidas" '+(TipoBuscador=="Forma1"?'onclick="buscarComidas2()"':'onclick="buscarComidas(this)"')+'>COMIDAS</button> ' +
        '</div> ' +
        
        '<div class="col-md-3 col-6"> ' +
        '<button class="form-control btn btn-sm btn-info" id="buscarBebidas" '+(TipoBuscador=="Forma1"?'onclick="buscarBebidas2()"':'onclick="buscarComidas(this)"')+'>BEBIDAS</button> ' +
        '</div> ' +
        
         '<div class="col-md-3 col-6"> ' +
        '<button class="form-control btn btn-sm btn-info" id="buscarHelados" '+(TipoBuscador=="Forma1"?'onclick="buscarHelados2()"':'onclick="buscarComidas(this)"')+'>HELADOS</button> ' +
        '</div> ' +
        
           '<div class="col-md-3 col-6"> ' +
        '<button class="form-control btn btn-sm btn-info" id="buscarOtros" '+(TipoBuscador=="Forma1"?'onclick="buscarOtros2()"':'onclick="buscarComidas(this)"')+'>OTROS</button> ' +
        '</div> ' +
        
        '<div class="col-md-12 col-12"> ' +
        '<button class="form-control btn btn-sm btn-primary" id="buscarPreCuenta" onclick="ReimprimirPedido('+ 
        "'" +codPed+"'"+
        ')">IMPRIMIR PRECUENTA</button> ' +
        '</div> ' +
        
        '</div> ' +

        '<div class="row"> ' +
        '<div class="col-md-12" style="margin-top: 5pt;text-align: center"> ' +
        '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 15pt;text-align:center;" id="lblTotalPedido" class="text-bold"> ' +
        'TOTAL: S/. 0.00 ' +
        '</span> ' +
        '</div> ' +
        '</div> ' +

        '<div class="row"> ' +
        '<div class="col-md-12 col-12"> ' +
        '<div class="table-responsive" id="divTablita"> ' + // style="height: 455px;"> ' +
        '<table id="tblPedido" class="table table-head-fixed text-nowrap table-bordered table-hover" style="font-family: Arial, Helvetica, sans-serif"> ' +
        '<thead class="table-sm" style="font-size: 9pt"> ' +
        '<tr> ' +

        '<th hidden>Codigo</th>' + //0
        '<th style="width: 30pt">Cant</th> ' + //1
        '<th>Descripción</th> ' + //2
        '<th class="text-right" style="width: 30pt">Precio</th> ' + //3
        '<th class="text-right" style="width: 30pt">Importe</th> ' + //4
        '<th class="text-center" style="width: 30pt" hidden>Comentario</th>' + //5
        '<th class="text-center" style="width: 30pt" hidden>DescripcionProducto</th>' + //6
        '<th hidden class="text-center" style="width: 30pt">St.</th>' + //7
        '<th hidden>ESTAPROGRAMADO</th>' + //8

        '</tr> ' +
        '</thead> ' +
        '<tbody id="tblDetallesPedido" style="font-size: 8pt"> ' +
        '</tbody> ' +
        '</table> ' +
        '</div> ' +
        '</div> ' +
        '</div> ' +
        '<div> ' +
        '<div class="row pt-2"> ' +

        '<div class="col-md-12"><span style="font-family: Arial, Helvetica, sans-serif; font-size: 9pt;">Items: <font id="totalItems">0</font></span></div>' +

        '<div class="col-md-1 col-2"> ' +
        '<button class="btn btn-sm btn-success" id="btnSumar" onclick="btnSumar()"> ' +
        '<i class="fas fa-plus"></i> ' +
        '</button>' +
        '</div> ' +

        '<div class="col-md-1 col-2"> ' +
        '<button class="btn btn-sm btn-danger" id="btnRestar" onclick="btnRestar()"> ' +
        '<i class="fas fa-minus"></i> ' +
        '</button>' +
        '</div> ' +

        '<div class="col-md-1 col-2"> ' +
        '<button class="btn btn-sm bg-blue" id="btnComentario" onclick="btnComentario()"> ' +
        '<i class="fas fa-book"></i> ' +
        '</button>' +
        '</div> ' +
        
        //'<div class="col-md-1 col-1"> ' +
        //'<button class="btn btn-sm bg-blue" id="btnCambiarPrecio" onclick="btnCambiarPrecio()"> ' +
        //'<i class="fas fa-dollar-sign"></i> ' +
        //'</button>' +
        //'</div> ' +

        '<div class="col-md-4 d-none d-sm-block"> </div> ' +

        '<div class="col-md-2 col-2 text-md-right text-right"> ' +
        '<button style="" class="btn btn-sm btn-danger" id="btnEliminarDetallePedido" onclick="btnEliminarDetallePedido()"> ' +
        '<i class="fas fa-times-circle"></i> ' +
        //'Quitar ' +
        '</button>' +
        '</div> ' +

        '<div class="col-md-2 col-4 text-md-right text-right"> ' +
        '<button style="" class="btn btn-sm btn-primary" id="btnActualizarPedido" onclick="btnActualizarPedido()"> ' +
        //'<i class="fas fa-bolt"></i> ' +
        'Guardar ' +
        '</button>' +
        '</div> ' +

        '</row>' +
        '</div>'
    return contenido
}

//*****************************************************************DETALLES PEDIDO
var cantDetallesGuardados = 0;
function htmlDetallesPedido(data) {
    cantDetallesGuardados = 0;
    data.forEach(element => {
        cantDetallesGuardados += 1;
        
        var ART_Codigo = element.ART_Codigo
        var DP_Cantidad = element.DP_Cantidad
        var DP_Descripcion = element.DP_Descripcion
        var DP_Precio = element.DP_Precio
        var DP_Importe = element.DP_Importe
        var DP_Comentario = element.DP_Comentario
        var ART_Descripcion = element.ART_Descripcion
        let PLATOS = parseInt(element.PLATOS)
        let VENDIDOS = parseInt(element.VENDIDOS)
        var ESTAPROGRAMADO = element.ESTAPROGRAMADO

        let _MeQuedan = 0
        if (ESTAPROGRAMADO == 'NO') _MeQuedan = 0
        else _MeQuedan = (PLATOS - VENDIDOS)

        var fila = '<tr style="cursor: pointer" estaprogramado="' + ESTAPROGRAMADO + '" codigo="' + ART_Codigo + '" codigoacompanante="' + element.ART_Codigo2 + '" eliminar="NO"> ' +

            '<td hidden>' + ART_Codigo + '</td>' +
            '<td>' + DP_Cantidad + '</td> ' +
            '<td>' + DP_Descripcion + '</td> ' +
            '<td class="text-right">' + DP_Precio + '</td> ' +
            '<td class="text-right text-bold">' + DP_Importe + '</td> ' +
            '<td hidden>' + (DP_Comentario == null ? '-' : DP_Comentario) + '</td>' +
            '<td hidden>' + ART_Descripcion + '</td>' +
            '<td hidden class="text-center">' + _MeQuedan + '</td> ' +
            '<td hidden>' + ESTAPROGRAMADO + '</td>' +

            '</tr> '

        $('#tblPedido').append(fila)
    });
    calcularTotal();
}

function calcularTotal() {
    let total = 0
    let totalItems = 0
    table = document.getElementById('tblPedido');
    for (i = 1; i < table.rows.length; i++) {
        if (table.rows[i].style.display != 'none') {
            total += parseFloat(table.rows[i].cells[4].innerText)
            totalItems += 1
        }
    }
    Pedido.PED_Total = total
    $('#lblTotalPedido').html('TOTAL: S/. ' + total.toFixed(2))
    $('#totalItems').html(totalItems)
    
    if (totalItems>=8){
        var intro = document.getElementById('divTablita');
        intro.style.height = '365px';
    }
    else{
        var intro = document.getElementById('divTablita');
        intro.style.height = null;
    }
}

var _accion = ''

function Abrir_Mesa() {
    _accion = 'NUEVO'

    if (MES_EstadoMesa == 'RESERVADO') {
        var rpta = confirm('LA MESA ESTÁ RESERVADA. ¿DESEA OCUPAR?')
        if (!rpta) return
    }
    
    $('#btnAbrir').prop('disabled', true)
    
    $.ajax({
        type: 'GET',
        url: RUTA_API + 'ListarPedidoxCodigoMesa/' + MES_Codigo,
        dataType: 'JSON',
        success: function(data) {
            var xPedido = data.pedido
            var tam = xPedido.length;
            if (tam > 0) {
                $('#btnAbrir').prop('disabled', false)
                swal({
                    title: 'Refrescar Zona de Mesas',
                    text: 'MESA ESTÁ OCUPADA',
                    timer: 5000
                })
                return
            }
            else{
                continuarAperturaMesa();
            }
        },
        error: function(error) {
            $('#btnAbrir').prop('disabled', false)
            console.log(error)
        }
    })
}
    
function continuarAperturaMesa()
{
    $.ajax({ 
        type: 'GET',
        url: RUTA_API + 'ListarCajaVer/'+sucursal,
        dataType: 'JSON',
        success: function(data) {
            var estado = "";
            data.forEach(element => {
                //if (element.CD_Almacen == sucursal)
                estado = element.CD_Estado;
            });
            
            if (estado == "" || estado == "Cerrado"){
                alert('Se debe aperturar una caja para abrir la mesa');
                return;
            }
      
            AtenderPedido();
        },
        error: function(error) {
            console.log(error)
        },
        beforeSend: function() {
            mostrarCargando('Verificando datos...');
        },
        complete: function() {
            cerrarCangando();
        }
    })
}

function mostrarCargando(msg) {
    $.blockUI({
        message: '<img src="../files/img/loader.gif" style="max-width: 80px;" /><p>' + msg + '</p>',
        overlayCSS: {
            backgroundColor: '#1b2024',
            opacity: 0.8,
            cursor: 'default'
        },
        css: {
            border: 0,
            color: '#fff',
            padding: 0,
            backgroundColor: 'transparent',
            cursor: 'default'
        }
    });
}

function cerrarCangando() {
    $.unblockUI();
}

function AtenderPedido() {

    codigoCliente = '';
    codigoMesa = MES_Codigo
    numeroPersonas = 0;

    if (_accion == 'NUEVO') {
        var _cli = String($('#txtcliente').val()).trim();
        var _dir = String($('#txtdireccionCliente').val()).trim();
        var _cel = String($('#txtcelularCliente').val()).trim();
        
        cliente = _cli + " | " + _cel + " | " + _dir; //$('#txtcliente').val().trim()
        mesero = ' ' // $('#txtmesero').val().trim()
        observaciones = $('#txtobservaciones').val().trim()
    } else {
        var tabActivo = $('#tabCliente').hasClass('active')
        if (tabActivo) {
            var _cli = String($('#txtcliente').val()).trim();
            var _dir = String($('#txtdireccionCliente').val()).trim();
            var _cel = String($('#txtcelularCliente').val()).trim();
                
            cliente = _cli + " | " + _cel + " | " + _dir; //$('#txtcliente').val().trim()
            mesero = ' ' // $('#txtmesero').val().trim()
            observaciones = $('#txtobservaciones').val().trim()
        } else {
            cliente = Pedido.PED_Cliente;
            mesero = ' ' // Pedido.PED_Mesero
            observaciones = Pedido.PED_Observaciones
        }
    }

    _servicioRecepcion = "";
    _totalServicios = 0;
    xDetallesPedidoNuevos = [];

    var table = document.getElementById('tblPedido');
    if (_accion != 'NUEVO') {
        for (i = 1; i < table.rows.length; i++) {
            if (table.rows[i].style.display != 'none') {
                var fila = $(table.rows[i])

                codigoPedido = table.rows[i].cells[0].innerText
                cantidad = table.rows[i].cells[1].innerText
                descripcion = table.rows[i].cells[2].innerText
                precio = table.rows[i].cells[3].innerText
                subTotal = table.rows[i].cells[4].innerText
                comentario = table.rows[i].cells[5].innerText
                codAcompanante = fila.attr('codigoacompanante');

                _servicioRecepcion = _servicioRecepcion + codigoPedido + ',' + cantidad + ',' + descripcion + ',' + precio + ',' + subTotal + ',' + codAcompanante + ',' + comentario + '|';
                _totalServicios = _totalServicios + parseFloat(subTotal);

                xDetallesPedidoNuevos.push({
                    ART_Codigo: codigoPedido,
                    DP_Descripcion: descripcion,
                    DP_Cantidad: cantidad,
                    DP_Precio: precio,
                })
            }
        }
    }

    tipoDocumento = '';
    serie = '';
    correlativo = '';
    subTotal = _totalServicios / parseFloat('1.18');
    _IGV = _totalServicios - (_totalServicios / parseFloat('1.18'));
    total = _totalServicios;
    codigoOperacionTarjeta = "";
    montoOperacionTarjeta = 0.00;
    tipoPago = '';
    estadoCuenta = 'PENDIENTE';
    p_estado = 'Habilitado';

    dispositivo = 'WEB';
    forma = 'MESAS';
    impreso = '';    

    estadoMESA_JE = MES_EstadoMesa
    if (_accion !== 'MODIFICAR' || estadoMESA_JE === 'RESERVADO') {
        $.ajax({
            type: 'POST',
            url: RUTA_API + 'RegistrarPedido',
            dataType: 'JSON',
            data: {
                PER_Codigo: PER_Codigo,
                codigoCliente: codigoCliente,
                codigoMesa: codigoMesa,
                nroPersonas: numeroPersonas,
                cliente: cliente,
                mesero: meserito,
                observaciones: observaciones,
                tipoDocumento: tipoDocumento,
                serie: serie,
                correlativo: correlativo,
                subTotal: subTotal,
                IGV: _IGV,
                total: total,
                tipoPago: tipoPago,
                estadoCuenta: estadoCuenta,
                estado: p_estado,
                codigoOperacion: codigoOperacionTarjeta,
                montoOperacionTarjeta: montoOperacionTarjeta,
                impreso: impreso,
                dispositivo: dispositivo,
                forma: forma,
                detallePedido: _servicioRecepcion,
                sucursal: sucursal
            },
            success: function(data) {      
                Piso_Click(_PisoSeleccionado, _CodPisoSeleccionado);          
                Mesa_Click(MES_Codigo, MES_Numero, 'OCUPADO', 'Abriendo')     
                //btnEnviarListadoMesas(MES_Codigo);
            },
            error: function(error) {
                console.log(error)
            },
            beforeSend: function() {
                mostrarCargando('Guardando datos...');
            },
            complete: function() {
                cerrarCangando();
            }
        });
    } else {
        $.ajax({
            type: 'POST',
            url: RUTA_API + 'ModificarPedido',
            dataType: 'JSON',
            data: {
                codigoPedido: Pedido.PED_Codigo,
                codigoCliente: codigoCliente,
                codigoMesa: codigoMesa,
                nroPersonas: numeroPersonas,
                cliente: cliente,
                mesero: meserito,
                observaciones: observaciones,
                tipoDocumento: tipoDocumento,
                serie: serie,
                correlativo: correlativo,
                subTotal: subTotal,
                IGV: _IGV,
                total: total,
                tipoPago: tipoPago,
                estadoCuenta: estadoCuenta,
                estado: p_estado,
                codigoOperacion: codigoOperacionTarjeta,
                montoOperacionTarjeta: montoOperacionTarjeta,
                impreso: impreso,
                dispositivo: dispositivo,
                forma: forma,
                detallePedido: _servicioRecepcion,
                detallePedidoActual: xDetallesPedidoActual,
                detallePedidoNuevos: xDetallesPedidoNuevos,
                sucursal: sucursal
            },
            success: function(data) {      
                console.log(data)
                Mesa_Click(MES_Codigo, MES_Numero, 'OCUPADO')
                    // alert('El pedido ha sido actualizado')
                swal({
                    title: 'Excelente',
                    text: '¡Pedido Actualizado!',
                    timer: 1500
                })
                btnEnviarListadoMesas(MES_Codigo);
            },
            error: function(error) {
                console.log(error.responseText)
            },
            beforeSend: function() {
                mostrarCargando('Guardando datos...');
            },
            complete: function() {
                cerrarCangando();
            }
        });
    }
}

function btnActualizarPedido() {
    _accion = 'MODIFICAR'
    var table = document.getElementById('tblPedido');
    if (table.rows.length - 1 == 0) {
        swal({
            title: 'ADVERTENCIA',
            text: 'INGRESE DETALLES DE PEDIDO',
            timer: 2000
        })
        return
    }
    
    
    $.ajax({
        type: 'GET',
        url: RUTA_API + 'PA_ObtenerEstadoSeEstaCobrando_PorCodigo/' + Pedido.PED_Codigo,
        dataType: 'JSON',
        success: function(data) {
            //console.log(data)
            var seEstaCobrando = data[0].PED_SeEstaCobrando;
            
            if (seEstaCobrando == 'SI'){
                swal({
                    title: 'No puede continuar',
                    text: 'Pedido de mesa se está cobrando.',
                    timer: 5000
                })
                return
            }
            else{
                continuarPrimero();
            }
        },
        error: function(error) {
            console.log(error)
        },
        beforeSend: function() {
            mostrarCargando('Obteniendo datos...');
        },
        complete: function() {
            cerrarCangando();
        }
    })
}

function continuarPrimero(){
    
    $.ajax({
        type: 'GET',
        url: RUTA_API + 'ListarPedidoxCodigoMesa/' + MES_Codigo,
        dataType: 'JSON',
        success: function(data) {
            // console.log(data)
            var xPedido = data.pedido
            xDetallesPedidoActual = data.detalles

            var tam = xPedido.length;
            if (tam > 0) {
                continuarGuardandoDatos();
            }
            else{
                swal({
                    title: 'Refrescar Zona de Mesas',
                    text: 'La mesa ya no está ocupada.',
                    timer: 5000
                })
                $('#tabPedido').html('');
                return
            }
        },
        error: function(error) {
            console.log(error)
        },
        beforeSend: function() {
            mostrarCargando('Obteniendo datos...');
        },
        complete: function() {
            cerrarCangando();
        }
    })
}

function continuarGuardandoDatos(){
    $('#btnActualizarPedido').prop('disabled', true)
    $('#btnEliminarDetallePedido').prop('disabled', true)
    $('#btnSumar').prop('disabled', true)
    $('#btnRestar').prop('disabled', true)
    $('#btnComentario').prop('disabled', true)
    $('#btnCambiarPrecio').prop('disabled', true)
    $('#buscarComidas').prop('disabled', true)
    $('#buscarPreCuenta').prop('disabled', true)
            
    AtenderPedido()
}

function btnEliminarDetallePedido() {
    if (filaSeleccionada == '') {
        swal({
            title: 'ADVERTENCIA',
            text: 'SELECCIONE ITEM',
            timer: 2000
        })
        return
    }

    var seElimina = filaSeleccionada.attr('eliminar')
    if (seElimina === 'NO') {
        //Obtener Permisos
        $.ajax({
            type: 'GET',
            url: RUTA_API + 'PA_ListarPermisosWeb_PorUsuario/'+PER_Codigo,
            dataType: 'JSON',
            data: {},
            success: function(data) {      
                var fila = data[0];
                if (fila.USU_DenegarTodo == "SI"){
                    swal({
                        title: '¡Bebida/Plato Fue Impreso!',
                        text: 'No tiene permiso para eliminar un detalle registrado.',
                        timer: 4500
                    });
                }
                else{
                    if (fila.USU_QuitarDetalle == "SI"){
                        var rpta = confirm('¿Desea eliminar el detalle?')
                        if (!rpta) return
                        filaSeleccionada.remove()
                        calcularTotal();
                        return;
                    }
                    else{
                        swal({
                            title: '¡Bebida/Plato Fue Impreso!',
                            text: 'No tiene permiso para eliminar un detalle registrado.',
                            timer: 4500
                        });       
                    }
                }
            },
            error: function(error) {
                console.log(error.responseText)
            },
            beforeSend: function() {
                mostrarCargando('Guardando datos...');
            },
            complete: function() {
                cerrarCangando();
            }
        });
    }
    else{
        var rpta = confirm('¿Desea eliminar el detalle?')
        if (!rpta) return
        filaSeleccionada.remove()
        calcularTotal();
        return;
    }
}

//*****************************************************************BOTÓN SUMAR
function btnSumar() {
    if (filaSeleccionada == '') {
        swal({
            title: 'ADVERTENCIA',
            text: 'SELECCIONE ITEM',
            timer: 2000
        })
        return
    }
    
    var seElimina = filaSeleccionada.attr('eliminar')

    if (seElimina === "NO")
    {
        //Obtener Permisos
        $.ajax({
            type: 'GET',
            url: RUTA_API + 'PA_ListarPermisosWeb_PorUsuario/'+PER_Codigo,
            dataType: 'JSON',
            data: {},
            success: function(data) {      
                var fila = data[0];
                if (fila.USU_DenegarTodo == "SI"){
                    swal({
                        title: '¡Bebida/Plato Fue Impreso!',
                        text: 'No tiene permiso para eliminar un detalle registrado.',
                        timer: 4500
                    });
                }
                else{
                    if (fila.USU_Aumentar == "SI"){
                        
                        var _Cantidad = parseFloat(filaSeleccionada.children(0)[1].innerText)
                        var _Descripcion = filaSeleccionada.children(0)[2].innerText
                        var _Precio = parseFloat(filaSeleccionada.children(0)[3].innerText)
                        var _Stock = parseFloat(filaSeleccionada.children(0)[7].innerText)
                        _Cantidad += 1
                    
                        var ESTAPROGRAMADO = filaSeleccionada.children(0)[8].innerText
                        if (ESTAPROGRAMADO == 'SI') {
                            if (_Stock - 1 < 0) {
                                var msj = 'CANTIDAD DE PLATOS LIBRES DE: ' + _Descripcion + ': ' + _Stock
                                if (_Stock < 0) {
                                    msj = 'EL PLATO ' + _Descripcion + ' SE ENCUENTRA AGOTADO'
                                }
                                swal({
                                    title: 'ADVERTENCIA',
                                    text: msj,
                                    timer: 2500
                                })
                                return
                            }
                            _Stock -= 1
                        }
                    
                        filaSeleccionada.children(0)[1].innerText = _Cantidad
                        filaSeleccionada.children(0)[4].innerText = parseFloat(_Cantidad * _Precio).toFixed(2)
                        filaSeleccionada.children(0)[7].innerText = _Stock
                    
                        calcularTotal()  
                        
                    }
                    else{
                        swal({
                            title: '¡Bebida/Plato Fue Impreso!',
                            text: 'No tiene permiso para aumentar cantidad de detalle registrado.',
                            timer: 4500
                        });       
                    }
                }
            },
            error: function(error) {
                console.log(error.responseText)
            },
            beforeSend: function() {
                mostrarCargando('Guardando datos...');
            },
            complete: function() {
                cerrarCangando();
            }
        });
    }
    else{
        var _Cantidad = parseFloat(filaSeleccionada.children(0)[1].innerText)
        var _Descripcion = filaSeleccionada.children(0)[2].innerText
        var _Precio = parseFloat(filaSeleccionada.children(0)[3].innerText)
        var _Stock = parseFloat(filaSeleccionada.children(0)[7].innerText)
        _Cantidad += 1
    
        var ESTAPROGRAMADO = filaSeleccionada.children(0)[8].innerText
        if (ESTAPROGRAMADO == 'SI') {
            if (_Stock - 1 < 0) {
                var msj = 'CANTIDAD DE PLATOS LIBRES DE: ' + _Descripcion + ': ' + _Stock
                if (_Stock < 0) {
                    msj = 'EL PLATO ' + _Descripcion + ' SE ENCUENTRA AGOTADO'
                }
                swal({
                    title: 'ADVERTENCIA',
                    text: msj,
                    timer: 2500
                })
                return
            }
            _Stock -= 1
        }
    
        filaSeleccionada.children(0)[1].innerText = _Cantidad
        filaSeleccionada.children(0)[4].innerText = parseFloat(_Cantidad * _Precio).toFixed(2)
        filaSeleccionada.children(0)[7].innerText = _Stock
    
        calcularTotal()   
    }
}

//*****************************************************************BOTÓN RESTAR
function btnRestar() {
    if (filaSeleccionada == '') {
        swal({
            title: 'ADVERTENCIA',
            text: 'SELECCIONE ITEM',
            timer: 2000
        })
        return
    }

    var seElimina = filaSeleccionada.attr('eliminar')
    if (seElimina === "NO"){
        //Obtener Permisos
        $.ajax({
            type: 'GET',
            url: RUTA_API + 'PA_ListarPermisosWeb_PorUsuario/'+PER_Codigo,
            dataType: 'JSON',
            data: {},
            success: function(data) {     
                var fila = data[0];
                if (fila.USU_DenegarTodo == "SI"){
                    swal({
                        title: '¡Bebida/Plato Fue Impreso!',
                        text: 'No tiene permiso para disminuir un detalle registrado.',
                        timer: 4500
                    });
                }
                else{
                    if (fila.USU_Disminuir == "SI"){
                        
                        var _Cantidad = parseFloat(filaSeleccionada.children(0)[1].innerText)
                        var _Descripcion = filaSeleccionada.children(0)[2].innerText
                        var _Precio = parseFloat(filaSeleccionada.children(0)[3].innerText)
                        var _Stock = parseFloat(filaSeleccionada.children(0)[7].innerText)
                        _Cantidad -= 1
                    
                        var ESTAPROGRAMADO = filaSeleccionada.children(0)[8].innerText
                        if (ESTAPROGRAMADO == 'SI') {
                            if (_Cantidad > 0) {
                                _Stock += 1
                            }
                        }
                        if (_Cantidad <= 0) _Cantidad = 1
                    
                        filaSeleccionada.children(0)[1].innerText = _Cantidad
                        filaSeleccionada.children(0)[4].innerText = parseFloat(_Cantidad * _Precio).toFixed(2)
                        filaSeleccionada.children(0)[7].innerText = _Stock
                    
                        calcularTotal();
                        
                    }
                    else{
                        swal({
                            title: '¡Bebida/Plato Fue Impreso!',
                            text: 'No tiene permiso para disminuir cantidad de detalle registrado.',
                            timer: 4500
                        });       
                    }
                }
            },
            error: function(error) {
                console.log(error.responseText)
            },
            beforeSend: function() {
                mostrarCargando('Guardando datos...');
            },
            complete: function() {
                cerrarCangando();
            }
        });
    }
    else{
        var _Cantidad = parseFloat(filaSeleccionada.children(0)[1].innerText)
        var _Descripcion = filaSeleccionada.children(0)[2].innerText
        var _Precio = parseFloat(filaSeleccionada.children(0)[3].innerText)
        var _Stock = parseFloat(filaSeleccionada.children(0)[7].innerText)
        _Cantidad -= 1
    
        var ESTAPROGRAMADO = filaSeleccionada.children(0)[8].innerText
        if (ESTAPROGRAMADO == 'SI') {
            if (_Cantidad > 0) {
                _Stock += 1
            }
        }
        if (_Cantidad <= 0) _Cantidad = 1
    
        filaSeleccionada.children(0)[1].innerText = _Cantidad
        filaSeleccionada.children(0)[4].innerText = parseFloat(_Cantidad * _Precio).toFixed(2)
        filaSeleccionada.children(0)[7].innerText = _Stock
    
        calcularTotal()   
    }
}

//*****************************************************************BOTÓN COMENTARIO
function btnComentario() {
    if (filaSeleccionada == '') {
        swal({
            title: 'ADVERTENCIA',
            text: 'SELECCIONE ITEM',
            timer: 2000
        })
        return
    }

    var seElimina = filaSeleccionada.attr('eliminar')
    if (seElimina === "NO"){
        //Obtener Permisos
        $.ajax({
            type: 'GET',
            url: RUTA_API + 'PA_ListarPermisosWeb_PorUsuario/'+PER_Codigo,
            dataType: 'JSON',
            data: {},
            success: function(data) {     
                var fila = data[0];
                if (fila.USU_DenegarTodo == "SI"){
                    swal({
                        title: '¡Bebida/Plato Fue Impreso!',
                        text: 'No tiene permiso para comentar plato registrado.',
                        timer: 4500
                    });
                }
                else{
                    if (fila.USU_Comentar == "SI"){
                        
                        var DP_Comentario = filaSeleccionada.children(0)[5].innerText
                        if (DP_Comentario.trim() == '-') DP_Comentario = ''
                        $('#txtComentario').val(DP_Comentario)
                        $('#modalComentario').modal('show')
                        
                    }
                    else{
                        swal({
                            title: '¡Bebida/Plato Fue Impreso!',
                            text: 'No tiene permiso para comentar plato registrado.',
                            timer: 4500
                        });       
                    }
                }
            },
            error: function(error) {
                console.log(error.responseText)
            },
            beforeSend: function() {
                mostrarCargando('Guardando datos...');
            },
            complete: function() {
                cerrarCangando();
            }
        });
    }
    else{
        var DP_Comentario = filaSeleccionada.children(0)[5].innerText
        if (DP_Comentario.trim() == '-') DP_Comentario = ''
        $('#txtComentario').val(DP_Comentario)
        $('#modalComentario').modal('show')   
    }
}

function btnOkComentario() {
    var DP_Comentario = $('#txtComentario').val()
    var descripcionNueva = ''
    if (DP_Comentario.trim() == '') descripcionNueva = filaSeleccionada.children(0)[6].innerText
    else descripcionNueva = filaSeleccionada.children(0)[6].innerText + ' -' + DP_Comentario

    for (i = 1; i < table.rows.length; i++) {
        if (table.rows[i].style.display != 'none') {
            if (descripcionNueva == table.rows[i].cells[2].innerText) {
                alert('ADVERTENCIA: EXISTE UN PLATO CON EL MISMO COMENTARIO\n' +
                    'PUEDE AUMENTAR/DISMINUIR O QUITAR EL PLATO CON EL COMENTARIO')
                $('#txtComentario').focus()
                return
            }
        }
    }

    filaSeleccionada.children(0)[2].innerText = descripcionNueva
    filaSeleccionada.children(0)[5].innerText = DP_Comentario
    filaSeleccionada = ''
    $('#modalComentario').modal('hide')
}

function btnCancelComentario() {
    filaSeleccionada = ''
    $('#modalComentario').modal('hide')
}

function esMovil() {
    var useragent = navigator.userAgent || navigator.vendor || window.opera;
    var ismobile = /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|zh-cn|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(useragent) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(useragent.substr(0, 4));
    return ismobile
}

function btnCambiarPrecio() {
    
    
    if (filaSeleccionada == '') {
        swal({
            title: 'ADVERTENCIA',
            text: 'SELECCIONE ITEM',
            timer: 2000
        })
        return
    }

    var seElimina = filaSeleccionada.attr('eliminar')
    if (seElimina === "NO"){
        //Obtener Permisos
        $.ajax({
            type: 'GET',
            url: RUTA_API + 'PA_ListarPermisosWeb_PorUsuario/'+PER_Codigo,
            dataType: 'JSON',
            data: {},
            success: function(data) {     
                var fila = data[0];
                if (fila.USU_DenegarTodo == "SI"){
                    swal({
                        title: '¡Bebida/Plato Fue Impreso!',
                        text: 'No tiene permiso para cambiar precio plato registrado.',
                        timer: 4500
                    });
                }
                else{
                    if (fila.USU_CambiarPrecio == "SI"){
                        
                        var pre = filaSeleccionada.children(0)[3].innerText;
                        $('#txtPrecioNuevo').val(pre);
                        $('#modalCambiarPrecio').modal('show')   
                        
                    }
                    else{
                        swal({
                            title: '¡Bebida/Plato Fue Impreso!',
                            text: 'No tiene permiso para cambiar precio plato registrado.',
                            timer: 4500
                        });       
                    }
                }
            },
            error: function(error) {
                console.log(error.responseText)
            },
            beforeSend: function() {
                mostrarCargando('Guardando datos...');
            },
            complete: function() {
                cerrarCangando();
            }
        });
    }
    else{
        var pre = filaSeleccionada.children(0)[3].innerText;
        $('#txtPrecioNuevo').val(pre);
        $('#modalCambiarPrecio').modal('show')   
    }
    
}

function btnCancelCambiarPrecio(){
    $('#modalCambiarPrecio').modal('hide')
}

function btnOkCambiarPrecio(){
    if (isNaN($('#txtPrecioNuevo').val()))
    {
        alert('Debe ingresar un valor válido para precio');
        $('#txtPrecioNuevo').focus();
        return;
    }
    
    var _Cantidad = parseFloat(filaSeleccionada.children(0)[1].innerText)
    var _Precio = parseFloat($('#txtPrecioNuevo').val())

    filaSeleccionada.children(0)[1].innerText = _Cantidad;
    filaSeleccionada.children(0)[3].innerText = _Precio.toFixed(2);
    filaSeleccionada.children(0)[4].innerText = parseFloat(_Cantidad * _Precio).toFixed(2)
    $('#modalCambiarPrecio').modal('hide')
    $('#txtPrecioNuevo').val('');

    calcularTotal()
}

function ReimprimirPedido(codPed){
    console.log(codPed)
    var table = document.getElementById('tblPedido');
    if (table.rows.length - 1 == 0) {
        swal({
            title: 'ADVERTENCIA',
            text: 'INGRESE DETALLES DE PEDIDO',
            timer: 2000
        })
        return
    } else if (cantDetallesGuardados == 0){
        swal({
            title: 'ADVERTENCIA',
            text: 'PRIMERO DEBE GUARDAR LOS CAMBIOS',
            timer: 3000
        })
        return
    }
    
    $.ajax({
        type: 'POST',
        url: RUTA_API + 'ReimprimirPedido/'+codPed,
        dataType: 'JSON',
        data: {
            codigoPedido: codPed
        },
        success: function(data) {  
            console.log(data)
            swal({
                title: 'Excelente',
                text: '¡Pedido enviado a impresión!',
                timer: 1500
            })
        },
        error: function(error) {
            console.log(error.responseText)
        },
        beforeSend: function() {
            mostrarCargando('Ejecutando Acción...');
        },
        complete: function() {
            cerrarCangando();
        }
    });
}



