<?php

namespace App\Http\Controllers;

use App\ArrayList;
use App\Models\Mesa;
use App\Traits\Conexion;
use App\Traits\util;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class MesaController extends Controller
{    
    use util;
    public function ListarMesasPorUbicacion($ubicacion)
    {        
        $body = [
            'accion' => 'PA_ListarMesasxUbicacion',
            'ubicacion' => $ubicacion,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ListarZonasMesa($descripcion)
    {        
        $body = [
            'accion' => 'PA_ListarZonasMesa',
            'Descripcion' => $descripcion,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
}
