<?php

namespace App\Http\Controllers;

use App\ArrayList;
use App\Models\Categoria;
use App\Models\Cliente;
use App\Models\DetallePedido;
use App\Models\Mesa;
use App\Models\Pedido;
use App\Models\Personal;
use App\Traits\Conexion;
use App\Traits\util;
use App\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;
use App\Services\PDFService;

class PedidoController extends Controller
{
    protected $pdfService;

    public function __construct(PDFService $pdfService)
    {
        $this->pdfService = $pdfService;
    }

    use util;
    public function index(Request $request)
    {
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }

        session(['pos' => '1', 'subitem' => '1.1']);

        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);
        $documentTypes = ['', 'FACTURA', 'BOLETA', 'TICKET'];

        $buscar_cliente = 0;

        $desde = $request->desde;
        $hasta = $request->hasta;
        $idcliente = $request->idcliente;
        $documentTypeSelected = $request->tipoDocumento;


        if ($desde != null && $hasta != null) {
            session(['VentasGenerales_desde' => $desde]);
            session(['VentasGenerales_hasta' => $hasta]);
        }
        $desde = session('VentasGenerales_desde');
        $hasta = session('VentasGenerales_hasta');

        $ndesde = '';
        $nhasta = '';

        if ($desde != null && $hasta != null) {
            $data = explode('/', $desde);
            $ndesde = $data[2] . '' . $data[1] . '' . $data[0];
            $data = explode('/', $hasta);
            $nhasta = $data[2] . '' . $data[1] . '' . $data[0];

            if ($idcliente != null) {
                session(['VentasGenerales_idcliente' => $idcliente]);
            }
            $idcliente = session('VentasGenerales_idcliente');
            if ($idcliente != null && $idcliente != 0) {
                $buscar_cliente = $idcliente;
            }
        } else {
            $desde = date('d/m/Y');
            $hasta = date('d/m/Y');
            $ndesde = date('Ymd');
            $nhasta = date('Ymd');
        }

        $contado = 0;
        $credito = 0;
        $total = 0;

        $docCliente = '';
        $docRazonSocial = '';
        if ($buscar_cliente != 0) {
            $docCliente = 'doc';
            $docRazonSocial = 'cliente';

            $body = [
                'accion' => 'PA_ObtenerCliente_PorCodigo',
                'cli_id' => $buscar_cliente,
            ];
            $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
            $datos = $datos->json();

            foreach ($datos as $item) {
                $docCliente = $item['docCliente'];
                $docRazonSocial = $item['docRazonSocial'];
            }
        }

        $body = [
            'accion' => 'PA_ListarVentas',
            'Inicial' => $ndesde,
            'Final' => $nhasta,
            'cliente' => $buscar_cliente,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();

        $ventas = array();
        if ($documentTypeSelected) {
            $datos = array_filter($datos, function ($item) use ($documentTypeSelected) {
                return $item['VEN_TipoDocumento'] === $documentTypeSelected;
            });
        }
        foreach ($datos as $item) {

            if ($item['VEN_Condicion'] == 'CONTADO') $contado += $item['VEN_Total'];
            else $credito += $item['VEN_Total'];

            $fila = [
                'idventa' => $item['VEN_Codigo'],
                'fecha_sistema' => Carbon::parse($item['VEN_FechaEmision'])->format('d-m-Y h:i a'),
                'nroventa' => $item['VEN_Serie'],
                'doccliente' => $item['cli_nro_doc'],
                'cliente' => $item['cli_razon_social'],
                'condicion' => $item['VEN_Condicion'],
                'total' => $item['VEN_Total']
            ];
            array_push($ventas, $fila);
        }

        $total = $contado + $credito;

        if ($idcliente == 0) $idcliente = null;

        return view('Pedidos.index', compact('user', 'desde', 'hasta', 'ventas', 'contado', 'credito', 'total', 'idcliente', 'docCliente', 'docRazonSocial', 'documentTypes', 'documentTypeSelected'));
    }

    public function ListarClientes(Request $request)
    {

        $buscar = $request->buscar;

        $body = [
            'accion' => 'PA_ListarClientes',
            'buscar' => $buscar,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();

        $datitos = array();

        foreach ($datos as $item) {
            array_push(
                $datitos,
                [
                    'label' =>  $item['cli_nro_doc'] . ' - ' . ' ' . $item['cli_razon_social'],
                    'codigo' => $item['cli_id'],
                    'nrodoc' => $item['cli_nro_doc'],
                    'cliente' => $item['cli_razon_social'],
                    'celular' => $item['cli_telefono'],
                    'direccion' => $item['cli_direccion']
                ]
            );
        }

        return ['rpta' => 'ok', 'data' => $datitos];
    }

    public function PA_ObtenerEstadoSeEstaCobrando_PorCodigo($codigo)
    {
        $body = [
            'accion' => 'PA_ObtenerEstadoSeEstaCobrando_PorCodigo',
            'PER_Codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data = $datos->json();

        return response()->json($data);
    }

    public function PA_InsertarFormularioDeliveryMostrador(Request $request)
    {
        $obj = [
            'FDM_Codigo' => '',
            'FDM_Tipo' => $request->get('FDM_Tipo'),
            'FDM_Estado' => 'Habilitado',
            'FDM_NombreCliente' => 'PEDIDO ' . $request->get('FDM_Tipo'),
            'FDM_Celular' => '000 000 000',
        ];

        $body = [
            'accion' => 'PA_InsertarFormularioDeliveryMostrador',
            'obj' => $obj,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data = $datos->json();

        return response()->json($data);
    }

    //FUNCIONES MIGRADAS
    use Conexion;
    public function ListarPedidoxCodigoMesa($codigo)
    {
        $body = [
            'accion' => 'PA_ListarPedidoxCodigoMesa',
            'codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data = $datos->json();

        $body = [
            'accion' => 'PA_ListarDetallesDePedidoxCodigoMesa',
            'codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data2 = $datos->json();

        $datos = [
            'pedido' => $data,
            'detalles' => $data2
        ];
        return response()->json($datos);
    }

    public function PA_ObtenerPedido_PorCodigo_WEB($codigo)
    {
        $body = [
            'accion' => 'PA_ObtenerPedido_PorCodigo_WEB',
            'codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data = $datos->json();

        $body = [
            'accion' => 'PA_ObtenerDetallePedido_PorCodigo_WEB',
            'codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data2 = $datos->json();

        $datos = [
            'pedido' => $data,
            'detalles' => $data2
        ];
        return response()->json($datos);
    }

    public function PA_ObtenerVenta_PorCodigo($codigo)
    {
        $body_cabecera = [
            'accion' => 'PA_ObtenerVenta_PorCodigo_Cabecera',
            'VEN_Codigo' => $codigo,
        ];
        $datos_cabecera = Http::post($this->urlBase . 'OperacionesCN.php', $body_cabecera);
        $data_cabecera = $datos_cabecera->json();

        $body_detalle = [
            'accion' => 'PA_ObtenerVenta_PorCodigo_Detalle',
            'VEN_Codigo' => $codigo,
        ];
        $datos_detalle = Http::post($this->urlBase . 'OperacionesCN.php', $body_detalle);
        $data_detalle = $datos_detalle->json();



        $datos = [
            'cabecera' => $data_cabecera,
            'detalles' => $data_detalle
        ];
        return response()->json($datos);
    }


    public function GenerarPDF(Request $request)
    {
        return response()->streamDownload(function () use ($request) {
            $body = $request->all(); // Todos los datos enviados desde el frontend
            $this->pdfService->createPDF($body);
        }, 'archivo.pdf');
    }


    
    public function PA_ObtenerVenta_PorCodigo_Cabecera($codigo)
    {
        $body = [
            'accion' => 'PA_ObtenerVenta_PorCodigo_Cabecera',
            'VEN_Codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data = $datos->json();

        $datos = [
            'cabecera' => $data
        ];
        return response()->json($datos);
    }


    public function PA_ObtenerDetallesVenta_PorCodigo($codigo)
    {
        $body = [
            'accion' => 'PA_ObtenerDetallesVenta_PorCodigo',
            'VEN_Codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data = $datos->json();

        $datos = [
            'detalles' => $data
        ];
        return response()->json($datos);
    }


    public function PA_ObtenerArchivo_PorCodigo($codigo, $tipo)
    {
        $body = [
            'accion' => 'PA_ObtenerArchivo_PorCodigo',
            'VEN_Codigo' => $codigo,
            'AV_Tipo' => $tipo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $array = json_decode($datos, true);

        $cadenaHexadecimal = "";
        $nombre = "";
        foreach ($array as $item) {
            $cadenaHexadecimal = $cadenaHexadecimal . $item['AV_Archivo'];
            $nombre = $item['AV_NombreArchivo'];
        }

        if ($cadenaHexadecimal != "") {
            $cadenaBin = hex2bin($cadenaHexadecimal);
            $cadenaBase64Codigificado = base64_encode($cadenaBin);

            //$cadenaBase64Decodificado = base64_decode($cadenaBase64Codigificado, true);
            //if (Storage::disk('docTemporal')->exists($nombre)){
            //    Storage::disk('docTemporal')->delete($nombre);
            //}
            //Storage::disk('docTemporal')->put($nombre,  $cadenaBase64Decodificado); //Descomentar para guardar archivo generado

            return ['rpta' => 'ok', 'ruta' => '/files/Temporal/' . $nombre, 'nombre' => $nombre, 'uri' => 'data:@file/zip;base64,' . $cadenaBase64Codigificado];
        } else {
            return ['rpta' => 'error', 'ruta' => 'Archivo no encontrado', 'nombre' => '', 'uri' => ''];
        }


        //$pdf64 = 'DQotIGxvdGVzIHBvciB2ZW50YSBwYXJhIGxhIHV0aWxpZGFkDQotIHJlcG9ydGUgZGUgdmVudGFzIHBvciBpbmdlbmlvcyBkZSBjYW1wbw0KLSBpbXByZXNpb24gcG9yIHJlZCBBNCANCi0gYWxlcnRhIGRlIGZl//Y2hhIGRlIGNhZHVjaWRhZCBjb21vIHByb2R1Y3Rvcw0KLSByZXBvcnRlIGRlIHN0b2NrIG1pbmltbw0KLSBwYXBlbGVyYSBkZSBob2phcyBkZSBsZXRyYSBjb24gbW90aXZvDQotIHZlbnRhIHBvciAyIHVuaWRhZGVzI//GRlIG1lZGlkYQ0KLSA=';
        //$pdf = base64_decode($pdf64, true);
        //$nombre = 'COTIZACION 000011.txt';

        //Storage::disk('docTemporal')->put($nombre, $pdf);
        //return ['rpta' => 'ok', 'ruta' => '/files/Temporal/'.$nombre, 'nombre' => $nombre];
    }
    public function PA_ObtenerProducto_PorID($productId)
    {
        $body = [
            'accion' => 'PA_ObtenerProducto_PorID',
            'productId' => $productId,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data = $datos->json();
        return response()->json($data);
    }
    
    public function PA_ObtenerFotoProducto_PorID($productId)
    {
        $body = [
            'accion' => 'PA_ObtenerFotoProducto_PorID',
            'productId' => $productId,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $array = json_decode($datos, true);
        
        //--------------------------------------------------------------
        //------------------------- IMAGEN 1 ---------------------------
        //--------------------------------------------------------------
        $imagen1 = "";
        foreach ($array as $parte) {
            if ($parte[4] == 1){
                $imagen1 = $imagen1 . $parte[3];   
            }
        }
        
        if ($imagen1 != ""){
            $imagen1_bin = hex2bin($imagen1);
            $imagen1_base64 = base64_encode($imagen1_bin);    
            $imagen1 = 'data:image/png;base64,' . $imagen1_base64;
        }else{
            $imagen1 = '/files/img/no-logo.png';
        }
         
        //--------------------------------------------------------------
        //------------------------- IMAGEN 2 ---------------------------
        //--------------------------------------------------------------
        $imagen2 = "";
        foreach ($array as $parte) {
            if ($parte[4] == 2){
                $imagen2 = $imagen2 . $parte[3];   
            }
        }
        
        if ($imagen2 != ""){
            $imagen2_bin = hex2bin($imagen2);
            $imagen2_base64 = base64_encode($imagen2_bin);    
            $imagen2 = 'data:image/png;base64,' . $imagen2_base64;
        }else{
            $imagen2 = '/files/img/no-logo.png';
        }
        
        //--------------------------------------------------------------
        //------------------------- IMAGEN 3 ---------------------------
        //--------------------------------------------------------------
        $imagen3 = "";
        foreach ($array as $parte) {
            if ($parte[4] == 3){
                $imagen3 = $imagen3 . $parte[3];   
            }
        }
        
        if ($imagen3 != ""){
            $imagen3_bin = hex2bin($imagen3);
            $imagen3_base64 = base64_encode($imagen3_bin);    
            $imagen3 = 'data:image/png;base64,' . $imagen3_base64;
        }else{
            $imagen3 = '/files/img/no-logo.png';
        }
        
        //--------------------------------------------------------------
        //------------------------- IMAGEN 4 ---------------------------
        //--------------------------------------------------------------
        $imagen4 = "";
        foreach ($array as $parte) {
            if ($parte[4] == 4){
                $imagen4 = $imagen4 . $parte[3];   
            }
        }
        
        if ($imagen4 != ""){
            $imagen4_bin = hex2bin($imagen4);
            $imagen4_base64 = base64_encode($imagen4_bin);    
            $imagen4 = 'data:image/png;base64,' . $imagen4_base64;
        }else{
            $imagen4 = '/files/img/no-logo.png';
        }
        
        $respuesta = [
            'img1' => $imagen1,
            'img2' => $imagen2,
            'img3' => $imagen3,
            'img4' => $imagen4
        ];   
        
        return response()->json($respuesta);
    }

    public function PA_ObtenerFormularioDeliveryMostrador_PorCodigo($codigo)
    {
        $body = [
            'accion' => 'PA_ObtenerFormularioDeliveryMostrador_PorCodigo',
            'FDM_Codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $data = $datos->json();
        return response()->json($data);
    }

    public function ListarDetallesDePedidoxCodigoMesa($codigo)
    {
        $body = [
            'accion' => 'PA_ListarDetallesDePedidoxCodigoMesa',
            'codigo' => $codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return response()->json($datos);
    }

    public function GenerarCodigo()
    {
        $codigoPedido = "";
        $body = [
            'accion' => 'PA_GeneraCodigoPedido',
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();

        try {
            $fila = $datos[0];
            $codigoPedido = $fila['Codigo'];
        } catch (Exception $ex) {
            $codigoPedido = 'ERROR';
        }

        return json_encode(['codigoPedido' => $codigoPedido]);
    }

    public function RegistrarPedido(Request $request)
    {
        $PER_Codigo = $request->get('PER_Codigo');
        $codigoCliente = $request->get('codigoCliente');
        $codigoMesa = $request->get('codigoMesa');
        $nroPersonas = $request->get('nroPersonas');
        $cliente = $request->get('cliente');
        $mesero = $request->get('mesero');
        $observaciones = $request->get('observaciones');
        $tipoDocumento = $request->get('tipoDocumento');
        $serie = $request->get('serie');
        $correlativo = $request->get('correlativo');
        $subTotal = $request->get('subTotal');
        $IGV = $request->get('IGV');
        $total = $request->get('total');
        $tipoPago = $request->get('tipoPago');
        $estadoCuenta = $request->get('estadoCuenta');
        $estado = $request->get('estado');
        $codigoOperacionTarjeta = $request->get('codigoOperacionTarjeta');
        $montoOperacionTarjeta = $request->get('montoOperacionTarjeta');
        $impreso = $request->get('impreso');
        $dispositivo = $request->get('dispositivo');
        $forma = $request->get('forma');
        $detallePedido = $request->get('detallePedido');
        $sucursal = $request->get('sucursal');

        $respuesta = "";
        // session_start();
        // $PER_Codigo = '000001    '; //$_SESSION['PER_Codigo'];

        $FDM_Codigo = '';
        $clienteJE = '';
        $celularJE = '';
        if ($request->get('Delivery_Mostrador') != null) {
            $FDM_Codigo = $request->get('codFormulario');
            $clienteJE = $request->get('clienteJE');
            $celularJE = $request->get('celularJE');
        }

        $pedido = [
            'CodCliente' => $codigoCliente,
            'CodMesa' => $codigoMesa,
            'NroPersonas' => $nroPersonas,
            'Cliente' => $cliente,
            'Mesero' => $mesero,
            'Observaciones' => $observaciones,
            'TipoDocumento' => $tipoDocumento,
            'Serie' => $serie,
            'Correlativo' => $correlativo,
            'SubTotal' => $subTotal,
            'IGV' => $IGV,
            'Total' => $total,
            'TipoPago' => $tipoPago,
            'EstadoCuenta' => $estadoCuenta,
            'Estado' => $estado,
            'CodigoOperacionTarjeta' => $codigoOperacionTarjeta,
            'MontoOperacionTarjeta' => $montoOperacionTarjeta,
            'Impreso' => $impreso,
            'Dispositivo' => $dispositivo,
            'Forma' => $forma,
            'DetallePedido' => $detallePedido,
            'PER_Codigo' => $PER_Codigo,
            'sucursal' => $sucursal,
            'FDM_Codigo' => $FDM_Codigo,
            'ClienteJE' => $clienteJE,
            'CelularJE' => $celularJE,
        ];

        $body = [
            'accion' => 'PA_REGISTRAR_PEDIDO',
            'pedido' => $pedido,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();
        return response()->json($datos);
    }

    public function ModificarPedido(Request $request)
    {
        $codigoPedido = $request->get('codigoPedido');
        $codigoCliente = $request->get('codigoCliente');
        $codigoMesa = $request->get('codigoMesa');
        $nroPersonas = $request->get('nroPersonas');
        $cliente = $request->get('cliente');
        $mesero = $request->get('mesero');
        $observaciones = $request->get('observaciones');
        $tipoDocumento = $request->get('tipoDocumento');
        $serie = $request->get('serie');
        $correlativo = $request->get('correlativo');
        $subTotal = $request->get('subTotal');
        $IGV = $request->get('IGV');
        $total = $request->get('total');
        $tipoPago = $request->get('tipoPago');
        $estadoCuenta = $request->get('estadoCuenta');
        $estado = $request->get('estado');
        $codigoOperacionTarjeta = $request->get('codigoOperacionTarjeta');
        $montoOperacionTarjeta = $request->get('montoOperacionTarjeta');
        $impreso = $request->get('impreso');
        $dispositivo = $request->get('dispositivo');
        $forma = $request->get('forma');
        $detallePedido = $request->get('detallePedido');

        $detallePedidoActual = (array) $request->get('detallePedidoActual');
        $detPedidoNuevos = (array) $request->get('detallePedidoNuevos');
        $detImpresion = [];

        //*** ANTIGUOS
        foreach ($detallePedidoActual as $it) {
            $ART_Codigo = $it['ART_Codigo'];
            $Descripcion = $it['DP_Descripcion'];
            $cantActual = $it['DP_Cantidad'];
            $precActual = $it['DP_Precio'];

            $existe = false;
            //***NUEVOS
            for ($i = 0; $i < count($detPedidoNuevos); $i++) {
                $ART_Codigo_ = $detPedidoNuevos[$i]['ART_Codigo'];
                $Descripcion_ = $detPedidoNuevos[$i]['DP_Descripcion'];
                $cantNueva = $detPedidoNuevos[$i]['DP_Cantidad'];
                $precNuevo = $detPedidoNuevos[$i]['DP_Precio'];

                if ($ART_Codigo == $ART_Codigo_ && $Descripcion == $Descripcion_ && $precActual == $precNuevo) {
                    if ($cantNueva > $cantActual) //Significa que se ha aumentado la cantidad de platos del mismo tipo
                    {
                        $fila = [
                            'Codigo' => $ART_Codigo_,
                            'Cantidad' => ($cantNueva - $cantActual),
                            'Descripcion' =>  $Descripcion_,
                            'Accion' => 'AGREGAR',
                            'Precio' => $precNuevo,
                        ];
                        array_push($detImpresion, $fila);
                    } else if ($cantNueva < $cantActual) //***Significa que se ha disminuido la cantidad de platos del mismo tipo
                    {
                        $fila = [
                            'Codigo' => $ART_Codigo_,
                            'Cantidad' => ($cantActual - $cantNueva),
                            'Descripcion' => $Descripcion_,
                            'Accion' => 'ANULAR',
                            'Precio' => $precNuevo,
                        ];
                        array_push($detImpresion, $fila);
                    }

                    $existe = true;
                    array_splice($detPedidoNuevos, $i, 1);
                    break;
                }
            }

            if (!$existe) {
                $fila = [
                    'Codigo' => $ART_Codigo,
                    'Cantidad' => $cantActual,
                    'Descripcion' => $Descripcion,
                    'Accion' => 'ANULAR',
                    'Precio' => $precActual,
                ];
                array_push($detImpresion, $fila);
            }
        }

        foreach ($detPedidoNuevos as $row) {
            $fila = [
                'Codigo' => $row['ART_Codigo'],
                'Cantidad' => $row['DP_Cantidad'],
                'Descripcion' => $row['DP_Descripcion'],
                'Accion' => 'AGREGAR',
                'Precio' => $row['DP_Precio']
            ];
            array_push($detImpresion, $fila);
        }

        // DB::delete('delete from dbo.TablaTemporal where Dato1 = ?', [$codigoPedido]);

        $body = [
            'accion' => 'PA_EliminarTablaTemporal_PorCodigoPedido',
            'codigo' => $codigoPedido,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();

        $detalleImpresion = array();
        foreach ($detImpresion as $it) {
            $ff = [
                'Codigo' => $codigoPedido,
                'CodigoProducto' => $it['Codigo'],
                'Cantidad' => $it['Cantidad'],
                'Descripcion' => $it['Descripcion'],
                'Accion' => $it['Accion'],
                'Precio' => $it['Precio'],
            ];
            array_push($detalleImpresion, $ff);
            // DB::insert(
            //     'insert into dbo.TablaTemporal (Codigo, Dato1, Dato2, Dato3, Dato4, Dato9) values (?, ?, ?, ?, ?, ?)',
            //     [$codigoPedido, $codigoPedido, $it['Codigo'], $it['Cantidad'], $it['Descripcion'], $it['Accion']]
            // );
        }

        $body = [
            'accion' => 'PA_InsertarTablaTemporal',
            'detalles' => $detalleImpresion,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();

        $FDM_Codigo = '';
        $clienteJE = '';
        $celularJE = '';
        if ($request->get('Delivery_Mostrador') != null) {
            $FDM_Codigo = $request->get('codFormulario');
            $clienteJE = $request->get('clienteJE');
            $celularJE = $request->get('celularJE');
        }

        $pedido = [
            'Codigo' => $codigoPedido,
            'CodCliente' => $codigoCliente,
            'CodMesa' => $codigoMesa,
            'NroPersonas' => $nroPersonas,
            'Cliente' => $cliente,
            'Mesero' => $mesero,
            'Observaciones' => $observaciones,
            'TipoDocumento' => $tipoDocumento,
            'Serie' => $serie,
            'Correlativo' => $correlativo,
            'SubTotal' => $subTotal,
            'IGV' => $IGV,
            'Total' => $total,
            'TipoPago' => $tipoPago,
            'EstadoCuenta' => $estadoCuenta,
            'Estado' => $estado,
            'CodigoOperacionTarjeta' => $codigoOperacionTarjeta,
            'MontoOperacionTarjeta' => $montoOperacionTarjeta,
            'Impreso' => $impreso,
            'Dispositivo' => $dispositivo,
            'Forma' => $forma,
            'DetallePedido' => $detallePedido,
            'FDM_Codigo' => $FDM_Codigo,
            'ClienteJE' => $clienteJE,
            'CelularJE' => $celularJE,
        ];

        $body = [
            'accion' => 'PA_MODIFICAR_PEDIDO',
            'pedido' => $pedido,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();

        return response()->json(['respuesta' => 'ok']);
    }

    public function ActualizaImpresion($codigo)
    {
        $body = [
            'accion' => 'ActualizaImpresionPedido',
            'codigo' => $codigo,
            'valor' => 'NO'
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();
        return response()->json(['Respuesta' => $datos]);
    }

    public function PA_SOLO_CLIENTE($PED_Codigo, Request $request)
    {
        $body = [
            'accion' => 'PA_SOLO_CLIENTE',
            'PED_Codigo' => $PED_Codigo,
            'cliente' => $request->get('cliente'),
            'observaciones' => $request->get('observaciones'),
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();
        return response()->json(['Respuesta' => $datos]);
    }

    //PA_VERIFICAR_PEDIDOS_ACTUALIZACION_AUTOMATICA
    public function VerificarPedidosActualizadosAutomatico()
    {
        $respuesta = "";
        $pedidosTotales = "";
        $pedidosPendientes = "";
        $pedidosCancelados = "";
        $cantidadPlatos = "";
        $pedidosEliminados = "";
        try {
            $cn = Conexion::getConexion(); //conexion
            $sp = "exec PA_VERIFICAR_PEDIDOS_ACTUALIZACION_AUTOMATICA";
            $rs = odbc_exec($cn, $sp);
            while (odbc_fetch_row($rs)) {
                $pedidosTotales =  odbc_result($rs, 1);
                $pedidosPendientes =  odbc_result($rs, 2);
                $pedidosCancelados =  odbc_result($rs, 3);
                $cantidadPlatos =  odbc_result($rs, 4);
                $pedidosEliminados =  odbc_result($rs, 5);
            }
        } catch (Exception $ex) {
            echo $ex;
        }
        return json_encode(['pt' => $pedidosTotales, 'pp' => $pedidosPendientes, 'pc' => $pedidosCancelados, 'cp' => $cantidadPlatos, 'pe' => $pedidosEliminados], JSON_FORCE_OBJECT);
    }

    public function VerificarCambiosMesa()
    {
        $mesaAnterior = "";
        $mesaNueva = "";
        $id = "";
        $estado = "";
        $fechaHora = "";
        $responsable = "";
        $cantidad = 0;

        $sp = "exec dbo.SP_VERIFICAR_CAMBIOS_MESAS";
        $data = DB::update($sp);
        $data = json_decode(json_encode($data), true);
        foreach ($data as $item) {
            $mesaAnterior =  $item['mesaAnterior'];
            $mesaNueva =   $item['mesaNueva'];
            $id =   $item['id'];
            $estado =   $item['estado'];
            $fechaHora =  $item['fechaHora'];
            $responsable =   $item['responsable'];
            $cantidad =  $item['cantidad'];
            break;
        }
        return response()->json(
            [
                'mesaAnterior' => $mesaAnterior,
                'mesaNueva' => $mesaNueva,
                'id' => $id,
                'estado' => $estado,
                'fecha_hora' => $fechaHora,
                'responsable' => $responsable,
                'cantidad' => $cantidad
            ]
        );
    }

    public function VerificarMesasAbiertas()
    {
        $id = 0;
        $codigoMesa = "";
        $cantidad = 0;

        $sp = "exec SP_VERIFICAR_MESAS_ABIERTAS";
        $data = DB::select($sp);
        $data = json_decode(json_encode($data), true);
        foreach ($data as $item) {
            $id = $item['id'];
            $codigoMesa = $item['codigoMesa'];
            $cantidad = $item['cantidad'];
            break;
        }

        return response()->json([
            'id' => $id,
            'codigoMesa' => $codigoMesa,
            'cantidad' => $cantidad
        ]);
    }

    public function VerificarMesasCanceladas()
    {
        $id = 0;
        $codigoMesa = "";
        $cantidad = 0;

        $sp = "exec SP_VERIFICAR_MESAS_CANCELADAS";
        $data = DB::select($sp);
        $data = json_decode(json_encode($data), true);
        foreach ($data as $item) {
            $id = $item['id'];
            $codigoMesa = $item['codigoMesa'];
            $cantidad = $item['cantidad'];
            break;
        }

        return response()->json([
            'id' => $id,
            'codigoMesa' => $codigoMesa,
            'cantidad' => $cantidad
        ]);
    }


    public function VerificarMesasCobradas()
    {
        $id = 0;
        $codigoMesa = "";
        $cantidad = 0;

        $sp = "exec SP_VERIFICAR_MESAS_COBRADAS";
        $data = DB::select($sp);
        $data = json_decode(json_encode($data), true);
        foreach ($data as $item) {
            $id = $item['id'];
            $codigoMesa = $item['codigoMesa'];
            $cantidad = $item['cantidad'];
            break;
        }

        return response()->json([
            'id' => $id,
            'codigoMesa' => $codigoMesa,
            'cantidad' => $cantidad
        ]);
    }

    public function VerificarMesasReservadas()
    {
        $id = 0;
        $codigoMesa = "";
        $cantidad = 0;

        $sp = "exec SP_VERIFICAR_MESAS_RESERVADAS";
        $data = DB::select($sp);
        $data = json_decode(json_encode($data), true);
        foreach ($data as $item) {
            $id = $item['id'];
            $codigoMesa = $item['codigoMesa'];
            $cantidad = $item['cantidad'];
            break;
        }

        return response()->json([
            'id' => $id,
            'codigoMesa' => $codigoMesa,
            'cantidad' => $cantidad
        ]);
    }



    public function PA_BuscarFormulario_PorCliente_WEB(Request $request)
    {
        $FDM_NombreCliente = $request->Cliente;
        $FDM_Tipo = $request->Tipo;

        $body = [
            'accion' => 'PA_BuscarFormulario_PorCliente_WEB',
            'FDM_NombreCliente' => $FDM_NombreCliente,
            'FDM_Tipo' => $FDM_Tipo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }


    public function VerParaLlevar()
    {
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }

        session(['pos' => '1', 'subitem' => '1.2']);

        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);

        if ($user['VerParaLlevar'] != "SI") {
            return redirect()->route('Pedido.index')->with('error', 'NO TIENE PERMISO PARA CONTINUAR.');
        }

        //Configurable
        $VerDatos = $user['VerDatos'];
        $TipoBuscador = $user['TipoBuscador']; //Forma1: Buscador actual; Forma2: Buscador anterior

        $comidas = array();
        $bebidas = array();

        if ($TipoBuscador == "Forma1") {
            $todo = (new ArticuloController())->ListarArticulosxDescripcion_WEB('');
            foreach ($todo as $f) {
                if ($f['CAT_Abreviatura'] == "COMIDAS") {
                    array_push($comidas, $f);
                } else {
                    array_push($bebidas, $f);
                }
            }
        }

        return view('Pedidos.indexMostrador', compact('user', 'comidas', 'sucursal', 'bebidas', 'VerDatos', 'TipoBuscador'));
    }


    public function VerDelivery()
    {
        if (session('PER_Codigo') === null) {
            return redirect('/');
        }

        session(['pos' => '1', 'subitem' => '1.3']);

        $CodPersonal = session('PER_Codigo');
        $sucursal = session('sucursal');
        $user = (new UserController())->PA_ObtenerPersonal_PorCodigo($CodPersonal);

        if ($user['VerDelivery'] != "SI") {
            return redirect()->route('Pedido.index')->with('error', 'NO TIENE PERMISO PARA CONTINUAR.');
        }

        //Configurable
        $VerDatos = $user['VerDatos'];
        $TipoBuscador = $user['TipoBuscador']; //Forma1: Buscador actual; Forma2: Buscador anterior

        $comidas = array();
        $bebidas = array();

        if ($TipoBuscador == "Forma1") {
            $todo = (new ArticuloController())->ListarArticulosxDescripcion_WEB('');
            foreach ($todo as $f) {
                if ($f['CAT_Abreviatura'] == "COMIDAS") {
                    array_push($comidas, $f);
                } else {
                    array_push($bebidas, $f);
                }
            }
        }

        return view('Pedidos.indexDelivery', compact('user', 'comidas', 'sucursal', 'bebidas', 'VerDatos', 'TipoBuscador'));
    }
}
