<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReservaController extends Controller
{
    public function ListarReservasPendientes_PorCliente($cliente)
    {
        $sp = "exec dbo.PA_ListarReservasPendientes_PorCliente '$cliente'";
        $data = DB::select($sp);
        $data = json_decode(json_encode($data), true);
        $newData = [];
        foreach ($data as $item) {
            $row = [
                'RES_Codigo' => $item['RES_Codigo'],
                'RES_FechaRegistro' => $item['RES_FechaRegistro'],
                'RES_Cliente' => $item['RES_Cliente'],
                'RES_Telefono' => $item['RES_Telefono'],
                'RES_FechaEmision' => Carbon::parse($item['RES_FechaEmision'])->format('d/m/Y'),
                'RES_HoraEmision' => Carbon::parse($item['RES_HoraEmision'])->format('h:i:s a'),
                'RES_Observacion' => $item['RES_Observacion'],
                'RES_EstadoReserva' => $item['RES_EstadoReserva'],
                'MES_Codigo' => $item['MES_Codigo'],
                'PER_Codigo' => $item['PER_Codigo'],
                'RES_Estado' => $item['RES_Estado'],
                'MES_Numero' => $item['MES_Numero'],
                'MES_Ubicacion' => $item['MES_Ubicacion']
            ];
            array_push($newData, $row);
        }
        return response()->json($newData);
    }
}
