<?php

namespace App\Http\Controllers;

use App\Traits\util;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class UserController extends Controller
{

    use util;
    public function mostrarLogin(Request $request)
    {
        if (session('PER_Codigo') != null)
        {
            return redirect()->route('home');
        }
        else{
            return view('login');
        }
    }

    public function verificarDatos(Request $request)
    {                
        $data = request()->validate([
            'txtusuario' => 'required',
            'txtclave' => 'required'
        ]);        

        $body =
            [
                'accion' => 'PA_ObtenerUsuario_PorNick',
                'user' => $request->get('txtusuario')
            ];
        $data = Http::post($this->urlBase . 'UserCN.php', $body);
        $data = $data->json();

        if (count($data) == 0) {
            return back()
                ->withErrors(['txtusuario' => 'Usuario no válido'])
                ->withInput(request(['txtusuario']));
        }
        
        $fila = $data[0];
        if ($request->get('txtclave') != $fila['usu_password']) {
            return back()
                ->withErrors(['txtclave' => 'Contraseña no válida'])
                ->withInput(request(['txtusuario']));
        }
        
        $sucursal = "PRINCIPAL";
        $aux = $request->get('flexRadioDefault');
        if ($aux=='prin'){
            $sucursal='PRINCIPAL';
        }
        else{
            $sucursal='SUCURSAL';
        }

        session(['PER_Codigo' => $fila['PER_Codigo']]);
        session(['QuitarDetalle' => $fila['USU_QuitarDetalle']]);
        session(['sucursal' => $sucursal]);
        return redirect()->route('Almacen.VerComidas');
    }

    public function logout()
    {           
        session_start();
        session(['PER_Codigo' => null]);
        session(['QuitarDetalle' => null]);
        session(['sucursal' => null]);
        return redirect('/');
    }

    public function PA_ObtenerPersonal_PorCodigo_WEB($PER_Codigo)
    {
        $body = [
            'accion' => 'PA_ObtenerPersonal_PorCodigo',
            'per_codigo' => $PER_Codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function PA_ObtenerPersonal_PorCodigo($PER_Codigo)
    {
        $body = [
            'accion' => 'PA_ObtenerPersonal_PorCodigo',
            'per_codigo' => $PER_Codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        $datos = $datos->json();
         
        $user = array();
        foreach ($datos as $f) {
            $user = [
                'codigo' => $f['codigo'],
                'nick' => $f['nick'],
                'nombres' => $f['nombres'],
                'apellidos' => $f['apellidos'],
                'VerDatos' => $f['VerDatos'],
                'TipoBuscador' => $f['TipoBuscador'],
                'CD_Codigo' => $f['CD_Codigo'],
                'CD_Estado' => $f['CD_Estado'],
                
                'VerCaja' => $f['USU_VerCaja'],
                'VerIngresos' => $f['USU_VerIngresos'],
                'VerEgresos' => $f['USU_VerEgresos'],
                'ListarVentas' => $f['USU_VerListarVentas'],
                'VerComidas' => $f['USU_VerComidas'],
                'VerBebidas' => $f['USU_VerBebidas'],
                'VerInsumos' => $f['USU_VerInsumos'],
                'VerReportes' => $f['USU_VerReportes'],
                'VerMesas' => $f['USU_VerMesas'],
                'VerParaLlevar' => $f['USU_VerParaLlevar'],
                'VerDelivery' => $f['USU_Delivery'],
            ];
            break;
        }  
        
        return $user;
    }
    
    public function PA_OpcionQuitarDetalle_PorCodigo($PER_Codigo)
    {
        $body = [
            'accion' => 'PA_OpcionQuitarDetalle_PorCodigo',
            'per_codigo' => $PER_Codigo,
        ];
        $datos = Http::post($this->urlBase . 'OperacionesCN.php', $body);
        return $datos->json();
    }
    
    public function GetDni($dni){
        
        return "<script> function consultar(){ alert('hola') } consultar(); </script>"; 
        
        $url = 'https://api.apis.net.pe/v1/ruc?numero=20601167507';
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $headers = array(
            "Server: nginx/1.14.2",
            "Date: Sun, 18 Sep 2022 03:59:27 GMT",
            "Content-Type: application/json",
            "Content-Length: 440",
            "Connection: keep-alive",
            "X-Upstream: 127.0.0.1:3002"
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
        
        
        $respuesta = json_decode(curl_exec($curl));
        return var_dump($respuesta);
        
        curl_close($curl);
        //$respuesta = json_decode($response, true);
        //var_dump($respuesta);
        $resp = array(
                    "cui" => "0",
                    "apellido_paterno" => $respuesta->apellidoPaterno,
                    "apellido_materno" => $respuesta->apellidoMaterno,
                    "nombres" => $respuesta->nombres,
                    "dni" => $respuesta->numeroDocumento
                        );
        return json_encode($resp);
           
    }
    
    public function GetRuc($ruc){
        return $this->consultar_ruc($ruc);
    }
}
