<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * @property string $ART_Codigo
 * @property string $ART_CodigoUsuario
 * @property string $ART_Descripcion
 * @property string $ART_Descripcion2
 * @property float $ART_Stock
 * @property float $ART_Costo
 * @property float $ART_Precio1
 * @property string $CAT_Codigo
 * @property string $ART_Dato1
 * @property string $ART_Dato2
 * @property string $ART_Dato3
 * @property string $ART_Imagen
 * @property string $ART_FechaCreacion
 * @property string $ART_FechaEliminacion
 * @property string $ART_Motivo
 * @property string $ART_Estado
 * @property string $ART_Combinado
 * @property string $ART_Bebida
 * @property string $ART_CostoDirecto
 * @property Categoria $categoria
 * @property DetalleNotaSalida[] $detalleNotaSalidas
 * @property DetalleProforma[] $detalleProformas
 * @property DetalleAlmacen[] $detalleAlmacens
 * @property DetalleBoletum[] $detalleBoletas
 * @property DetalleFactura[] $detalleFacturas
 * @property DetalleNotaCredito[] $detalleNotaCreditos
 * @property DetalleVenta[] $detalleVentas
 * @property string $ART_EB1
 * @property string $ART_EB2
 * @property string $ART_EB3

 */
class Articulo extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'Articulos';
    public $timestamps = false;

    /**
     * The primary key for the model.
     * 
     * @var string
     */
    protected $primaryKey = 'ART_Codigo';

    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'string';

    /**
     * Indicates if the IDs are auto-incrementing.
     * 
     * @var bool
     */
    public $incrementing = false;

    /**
     * @var array
     */
    protected $fillable = ['ART_CodigoUsuario', 'ART_Descripcion', 'ART_Descripcion2', 'ART_Stock', 'ART_Costo', 'ART_Precio1', 'CAT_Codigo', 'ART_Dato1', 'ART_Dato2', 'ART_Dato3', 'ART_Imagen', 'ART_FechaCreacion', 'ART_FechaEliminacion', 'ART_Motivo', 'ART_Estado', 'ART_Combinado', 'ART_Bebida', 'ART_CostoDirecto','ART_EB1','ART_EB2','ART_EB3'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function categoria()
    {
        return $this->belongsTo('App\Categoria', 'CAT_Codigo', 'CAT_Codigo');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function detalleNotaSalidas()
    {
        return $this->hasMany('App\DetalleNotaSalida', 'ART_Codigo', 'ART_Codigo');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function detalleProformas()
    {
        return $this->hasMany('App\DetalleProforma', 'ART_Codigo', 'ART_Codigo');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function detalleAlmacens()
    {
        return $this->hasMany('App\DetalleAlmacen', 'ART_Codigo', 'ART_Codigo');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function detalleBoletas()
    {
        return $this->hasMany('App\DetalleBoletum', 'ART_Codigo', 'ART_Codigo');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function detalleFacturas()
    {
        return $this->hasMany('App\DetalleFactura', 'ART_Codigo', 'ART_Codigo');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function detalleNotaCreditos()
    {
        return $this->hasMany('App\DetalleNotaCredito', 'ART_Codigo', 'ART_Codigo');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function detalleVentas()
    {
        return $this->hasMany('App\DetalleVenta', 'ART_Codigo', 'ART_Codigo');
    }
}
