<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * @property string $CAT_Codigo
 * @property string $CAT_Nombre
 * @property string $CAT_Estado
 * @property string $CAT_Abreviatura
 * @property string $CAT_Imagen
 * @property string $CAT_NombreImagen
 * @property string $CAT_UrlImagen
 * @property Articulo[] $articulos
 */
class Categoria extends Model
{
    protected $table = 'Categorias';
    protected $primaryKey = 'CAT_Codigo';
    public $timestamps  = false;
    protected $keyType = 'string';
    public $incrementing = false;

    protected $fillable = [
        'CAT_Nombre',
        'CAT_Estado',
        'CAT_Abreviatura',
        'CAT_Imagen',
        'CAT_NombreImagen',
        'CAT_UrlImagen'
    ];

    protected $cast = [
        'CAT_Nombre' => 'string',
        'CAT_Estado' => 'string',
        'CAT_Abreviatura' => 'string',
        'CAT_Imagen' => 'string',
        'CAT_NombreImagen' => 'string',
        'CAT_UrlImagen' => 'string'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function articulos()
    {
        return $this->hasMany('App\Articulo', 'CAT_Codigo', 'CAT_Codigo');
    }
}
