<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * @property string $CLI_DNIRUC
 * @property string $CLI_Codigo
 * @property string $CLI_Tipo
 * @property string $CLI_RazonSocial
 * @property string $CLI_Denominacion
 * @property string $CLI_Email
 * @property string $CLI_Telefono
 * @property string $CLI_Direccion
 * @property string $CLI_Estado
 * @property string $CLI_Marca
 * @property string $CLI_Modelo
 * @property string $CLI_Vehiculo
 * @property string $CLI_Ciudad
 * @property string $CLI_Condicion
 * @property string $CLI_FechaNacimiento
 * @property Boletum[] $boletas
 * @property Factura[] $facturas
 * @property NotaCredito[] $notaCreditos
 * @property Proforma[] $proformas
 */
class Cliente extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'Cliente';
    public $timestamps = false;

    /**
     * The primary key for the model.
     * 
     * @var string
     */
    protected $primaryKey = 'CLI_DNIRUC';

    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'string';

    /**
     * Indicates if the IDs are auto-incrementing.
     * 
     * @var bool
     */
    public $incrementing = false;

    /**
     * @var array
     */
    protected $fillable = [
        'CLI_Codigo',
        'CLI_Tipo',
        'CLI_RazonSocial',
        'CLI_Denominacion',
        'CLI_Email',
        'CLI_Telefono',
        'CLI_Direccion',
        'CLI_Estado', 'CLI_Marca',
        'CLI_Modelo',
        'CLI_Vehiculo',
        'CLI_Ciudad',
        'CLI_Condicion',
        'CLI_FechaNacimiento'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function boletas()
    {
        return $this->hasMany('App\Boletum', 'CLI_DNIRUC', 'CLI_DNIRUC');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function facturas()
    {
        return $this->hasMany('App\Factura', 'CLI_DNIRUC', 'CLI_DNIRUC');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function notaCreditos()
    {
        return $this->hasMany('App\NotaCredito', 'CLI_DNIRUC', 'CLI_DNIRUC');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function proformas()
    {
        return $this->hasMany('App\Proforma', 'CLI_DNIRUC', 'CLI_DNIRUC');
    }
}
