<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * @property string $PED_Codigo
 * @property string $CLI_DNIRUC
 * @property string $PED_FechaRegistro
 * @property string $PED_HoraRegistro
 * @property string $MES_Codigo
 * @property string $PED_FechaEntrada
 * @property string $PED_HoraEntrada
 * @property int $PED_NroPersonas
 * @property string $PED_Cliente
 * @property string $PED_Mesero
 * @property string $PED_Observaciones
 * @property string $PED_FechaFacturacion
 * @property string $PED_HoraFacturacion
 * @property string $PED_TipoDocumento
 * @property string $PED_Serie
 * @property string $PED_Correlativo
 * @property float $PED_SubTotal
 * @property float $PED_IGV
 * @property float $PED_Total
 * @property string $PED_TipoPago
 * @property string $PED_EstadoCuenta
 * @property string $PED_Estado
 * @property string $PED_CodigoOperacionTarjeta
 * @property float $PED_MontoOperacionTarjeta
 * @property string $PED_Impreso
 * @property string $PED_Dispositivo
 * @property string $PED_Forma
 * @property float $PED_MontoEfectivo
 * @property string $PED_EstadoEnvio
 * @property string $PED_RespuestaSunat
 * @property string $PED_Condicion
 * @property string $PED_FechaVencimiento
 * @property string $PER_Codigo
 * @property string $PED_MotivoEliminacion
 * @property string $PED_FechaEliminacion
 * @property string $PED_CodigoUsuarioElimino
 * @property string $CD_Codigo
 * @property float $PED_Dscto
 * @property float $PED_TotalBruto
 * @property string $PR_Codigo
 */
class Pedido extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'Pedido';
    public $timestamps = false;

    /**
     * The primary key for the model.
     * 
     * @var string
     */
    protected $primaryKey = 'PED_Codigo';

    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'string';

    /**
     * Indicates if the IDs are auto-incrementing.
     * 
     * @var bool
     */
    public $incrementing = false;

    /**
     * @var array
     */
    protected $fillable = [
        'CLI_DNIRUC',
        'PED_FechaRegistro',
        'PED_HoraRegistro',
        'MES_Codigo',
        'PED_FechaEntrada',
        'PED_HoraEntrada',
        'PED_NroPersonas',
        'PED_Cliente',
        'PED_Mesero',
        'PED_Observaciones',
        'PED_FechaFacturacion',
        'PED_HoraFacturacion',
        'PED_TipoDocumento',
        'PED_Serie',
        'PED_Correlativo',
        'PED_SubTotal',
        'PED_IGV',
        'PED_Total',
        'PED_TipoPago',
        'PED_EstadoCuenta',
        'PED_Estado',
        'PED_CodigoOperacionTarjeta',
        'PED_MontoOperacionTarjeta',
        'PED_Impreso',
        'PED_Dispositivo',
        'PED_Forma',
        'PED_MontoEfectivo',
        'PED_EstadoEnvio',
        'PED_RespuestaSunat',
        'PED_Condicion',
        'PED_FechaVencimiento',
        'PER_Codigo',
        'PED_MotivoEliminacion',
        'PED_FechaEliminacion',
        'PED_CodigoUsuarioElimino',
        'CD_Codigo',
        'PED_Dscto',
        'PED_TotalBruto',
        'PR_Codigo'
    ];
}
