@extends('index')
@section('estilos')
    <link rel="stylesheet" href="/files/calendario/css/bootstrap-datepicker.standalone.css?v={{ date('d-m-Y h:i:s') }}">
@endsection
@section('contenido')
    <div class="card" style="margin-top: -15px">
        <div class="card-header border shadow">
            <!-- <a href="#"><i class="fas fa-arrow-left text-red"></i></a> -->
            <i class="fas fa-dollar-sign text-warning"></i>
            <font style="font-family:Arial, Helvetica, sans-serif; font-size: 12pt">
                {{ $caja['descripCaja'] }} <br>
            </font>
        </div>
        <div class="card-body border shadow">
            <form id="frmActualizar">
                <div class="row">
                    <div class="col-md-2 col-6">
                        <button type="button" class=" form-control btn btn-primary" onclick="AbrirModalCaja()">
                            <i class="fas fa-search"></i> Elegir caja </button>
                    </div>
                    <div class="col-md-2 col-6">
                        <button type="submit" class=" form-control btn btn-primary">
                            <i class="fas fa-bolt"></i> Actualizar </button>
                    </div>
                    <input type="text" name="cd" id="cd" hidden>
                </div>
            </form>
        </div>
        <div class="card-body border shadow">
            <div class="row">
                <div class="col-md-12">
                    <span class="d-block d-sm-none" style="font-size: 10pt">
                        Resumen de caja.
                    </span>
                    <div class="row">
                        <div class="col-md-3">
                            <label for="" style="color: blue;">SALDO INICIAL: S/. </label>
                            <input type="text" style="font-size: 16pt;" readonly class="text-center form-control" 
                            value="{{ number_format($caja['saldoinicial'], 2, '.', '') }}">
                        </div>
                        <div class="col-md-3">
                            <label for="" style="color: blue">+ INGRESOS: S/. </label>
                            <input type="text" style="font-size: 16pt;" readonly class="text-center form-control" 
                            value="{{ number_format($caja['ingresos'], 2, '.', '') }}">
                        </div>
                        <div class="col-md-3">
                            <label for="" style="color: blue">+ VENTAS: S/. </label>
                            <input type="text" style="font-size: 16pt;" readonly class="text-center form-control"
                            value="{{ number_format($caja['ventas'], 2, '.', '') }}">
                        </div>
                        <div class="col-md-3">
                            <label for="" style="color: red">- EGRESOS: S/. </label>
                            <input type="text" style="font-size: 16pt;" readonly class="text-center form-control"
                            value="{{ number_format($caja['egresos'], 2, '.', '') }}">
                        </div>
                        
                        <div class="col-md-3">
                            <label for="" style="color: blue">- YAPE: S/. </label>
                            <input type="text" style="font-size: 16pt;" readonly class="text-center form-control"
                            value="{{ number_format($caja['yape'], 2, '.', '') }}">
                        </div>
                        <div class="col-md-3">
                            <label for="" style="color: blue">- TARJETA: S/. </label>
                            <input type="text" style="font-size: 16pt;" readonly class="text-center form-control"
                            value="{{ number_format($caja['tarjeta'], 2, '.', '') }}">
                        </div>
                        <div class="col-md-3">
                            <label for="" style="color: blue">- PLIM: S/. </label>
                            <input type="text" style="font-size: 16pt;" readonly class="text-center form-control"
                            value="{{ number_format($caja['plim'], 2, '.', '') }}">
                        </div>
                        <div class="col-md-3">
                            <label for="" style="color: blue">- TRANSFERENCIA: S/. </label>
                            <input type="text" style="font-size: 16pt;" readonly class="text-center form-control"
                            value="{{ number_format($caja['transferencia'], 2, '.', '') }}">
                        </div>
                        
                        <div class="col-md-3">
                            <label for="" style="color: blue">= TOTAL EFECTIVO: S/. </label>
                            <input type="text" style="font-size: 16pt; font-weight: bold" readonly class="text-center form-control bg-yellow"
                            value="{{ number_format($caja['totalCaja'], 2, '.', '') }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <br>
    @include('Caja.modalBuscarCaja')
@endsection
@section('scripts')
    <script src="/files/calendario/js/bootstrap-datepicker.min.js?v={{ date('d-m-Y h:i:s') }}"></script>
    <script src="/files/calendario/locales/bootstrap-datepicker.es.min.js?v={{ date('d-m-Y h:i:s') }}"></script>
    <script src="/files/newJS/Caja.js?v={{ date('d-m-Y h:i:s') }}"></script>
@endsection
