@extends('index')
@section('estilos')
    <link rel="stylesheet" href="/files/calendario/css/bootstrap-datepicker.standalone.css?v={{ date('d-m-Y h:i:s') }}">
@endsection
@section('contenido')
    <div class="card" style="margin-top: -15px">
        <div class="card-header border shadow">
            <!-- <a href="#"><i class="fas fa-arrow-left text-red"></i></a> -->
            <i class="fas fa-dollar-sign text-warning"></i>
            <font style="font-family:Cambria; font-size: 12pt; font-weight: bold">
                {{ $descripCaja }} <br>
            </font>
        </div>
        <div class="card-body border shadow">
            <form id="frmActualizar">
                <div class="row">
                    <div class="col-md-3 col-12">
                        <label for="">DESDE:</label>
                        <div class="input-group date form_date" data-date-format="dd/mm/yyyy" data-provide="datepicker">
                            <input readonly type="text" class="form-control" name="desde" id="desde"
                                data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy" data-mask=""
                                im-insert="false" value="{{ $desde }}" placeholder="dd/mm/yyyy">
                            <div class="input-group-btn">
                                <button class="btn btn-primary date-set" type="button">
                                    <i class="fa fa-calendar"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-12">
                        <label for="">HASTA:</label>
                        <div class="input-group date form_date" data-date-format="dd/mm/yyyy" data-provide="datepicker">
                            <input readonly type="text" class="form-control" name="hasta" id="hasta"
                                data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy"
                                data-mask="dd/mm/yyyy" im-insert="false" value="{{ $hasta }}"
                                placeholder="dd/mm/yyyy">
                            <div class="input-group-btn">
                                <button class="btn btn-primary date-set" type="button">
                                    <i class="fa fa-calendar"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4"></div>
                    <div class="col-md-2 col-12">
                        <label for="">&nbsp;</label>
                        <button type="submit" class=" form-control btn btn-primary">
                            <i class="fas fa-search"></i> Actualizar </button>
                    </div>
                </div>
            </form>
        </div>
        <div class="card-body border shadow">
            <div class="row">
                <div class="col-md-12">
                    <span class="d-block d-sm-none" style="font-size: 10pt">
                        Resumen de caja.
                    </span>
                    <div class="row">
                        <div class="table-responsive">
                            <table class="table table-bordered table-sm table-striped">
                                <thead class="bg-black" style="font-family: Cambria; font-size: 10pt">
                                    <tr>
                                        <th class="text-center" style="width: 90px">FECHA Y HORA</th>
                                        <th class="text-center" style="width: 90px">DOCUMENTO</th>
                                        <th class="text-right" style="width: 80pt">MONTO (S/.)</th>
                                        <th style="width: 200px">CLIENTE</th>
                                    </tr>
                                </thead>
                                <?php $total = 0; ?>
                                <tbody style="font-family: Cambria; font-size: 9pt">
                                    @foreach ($datos as $c => $item)
                                        <tr>
                                            <td class="text-center">{{ \Carbon\Carbon::parse($item['VEN_Fecha'])->format('d/m/Y h:i a') }}</td>
                                            <td class="text-center">{{ $item['VEN_Tipo'].' / '.$item['VEN_Serie'] }}</td>
                                            <td class="text-right">{{ number_format($item['VEN_Total'], 2, '.', '') }}</td>
                                            <td>{{ $item['CLI_RazonSocial'] }}</td>
                                        </tr>
                                        <?php $total += $item['VEN_Total']; ?>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="row mt-2">
                        <label for="" style="color: blue; margin-top: 7px">TOTAL: S/. </label>
                        <div class="col-md-3 col-8">
                            <input type="text" class="text-center form-control" value="{{ number_format($total, 2, '.', '') }}" readonly>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <br>
@endsection
@section('scripts')
    <script src="/files/calendario/js/bootstrap-datepicker.min.js?v={{ date('d-m-Y h:i:s') }}"></script>
    <script src="/files/calendario/locales/bootstrap-datepicker.es.min.js?v={{ date('d-m-Y h:i:s') }}"></script>
    <script>
        $(document).ready(function() {
            $('#desde').datepicker({
                orientation: "bottom"
            })
            
            $('#hasta').datepicker({
                orientation: "bottom"
            })
        });

    </script>
@endsection
