<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});


Route::get('OpcionQuitarDetalle/{codigo}', 'UserController@PA_OpcionQuitarDetalle_PorCodigo');
Route::get('ListarCajaVer/{sucursal}', 'CajaController@ListarCajaVer');
Route::get('PA_ListarPermisosWeb_PorUsuario/{codigo}', 'CajaController@PA_ListarPermisosWeb_PorUsuario');
Route::get('ListarPersonal', 'PersonalController@ListarPersonal');
Route::get('ListarMesasPorUbicacion/{ubicacion}', 'MesaController@ListarMesasPorUbicacion');
Route::get('ListarPedidoxCodigoMesa/{codigo}', 'PedidoController@ListarPedidoxCodigoMesa');
Route::get('verificarCambios', 'PedidoController@VerificarCambios');
Route::get('verificarMesasAbiertas', 'PedidoController@VerificarMesasAbiertas');
Route::get('verificarMesasCanceladas', 'PedidoController@VerificarMesasCanceladas');
Route::get('verificarMesasCobradas', 'PedidoController@VerificarMesasCobradas');
Route::get('verificarMesasReservadas', 'PedidoController@VerificarMesasReservadas');
Route::get('ListarDetallesDePedidoxCodigoMesa/{codigo}', 'PedidoController@ListarDetallesDePedidoxCodigoMesa');

Route::post('RegistrarPedido', 'PedidoController@RegistrarPedido');
Route::post('ModificarPedido', 'PedidoController@ModificarPedido');
Route::get('ListarCategoriasPorAbreviatura/{abreviatura}', 'CategoriaController@ListarCategoriasPorAbreviatura');
Route::get('ListarArticulosxCategoria/{categoria}', 'ArticuloController@ListarArticulosxCategoria');
Route::get('ListarArticulosxDescripcion/{descripcion}', 'ArticuloController@ListarArticulosxDescripcion');
Route::get('ListarReservasPendientes_PorCliente/{cliente}', 'ReservaController@ListarReservasPendientes_PorCliente');
Route::post('ReimprimirPedido/{codigo}', 'PedidoController@ActualizaImpresion');
Route::post('SoloCliente/{codigo}', 'PedidoController@PA_SOLO_CLIENTE');

Route::get('ListarCategoriasPorAbreviatura/{abreviatura}', 'CategoriaController@ListarCategoriasPorAbreviatura');
Route::get('PA_ObtenerEstadoSeEstaCobrando_PorCodigo/{codigo}', 'PedidoController@PA_ObtenerEstadoSeEstaCobrando_PorCodigo');
Route::post('PA_ListarCajasxFecha', 'CajaController@PA_ListarCajasxFecha');
Route::post('PA_BuscarFormulario_PorCliente_WEB', 'PedidoController@PA_BuscarFormulario_PorCliente_WEB');
Route::get('PA_ObtenerPedido_PorCodigo_WEB/{codigo}', 'PedidoController@PA_ObtenerPedido_PorCodigo_WEB');
Route::get('PA_ObtenerFormularioDeliveryMostrador_PorCodigo/{codigo}', 'PedidoController@PA_ObtenerFormularioDeliveryMostrador_PorCodigo');
Route::post('PA_InsertarFormularioDeliveryMostrador', 'PedidoController@PA_InsertarFormularioDeliveryMostrador');

Route::get('GetDni/{dni}', 'UserController@GetDni');
Route::get('GetRuc/{ruc}', 'UserController@GetRuc');

Route::get('PA_ObtenerDetallesVenta_PorCodigo/{codigo}', 'PedidoController@PA_ObtenerDetallesVenta_PorCodigo');
Route::get('PA_ObtenerVenta_PorCodigo_Cabecera/{codigo}', 'PedidoController@PA_ObtenerVenta_PorCodigo_Cabecera');


Route::get('PA_ObtenerArchivo_PorCodigo/{codigo}/{tipo}', 'PedidoController@PA_ObtenerArchivo_PorCodigo');
Route::get('PA_ObtenerVenta_PorCodigo/{codigo}', 'PedidoController@PA_ObtenerVenta_PorCodigo');
Route::get('PA_ObtenerProducto_PorID/{productId}', 'PedidoController@PA_ObtenerProducto_PorID');
Route::get('PA_ObtenerFotoProducto_PorID/{productId}', 'PedidoController@PA_ObtenerFotoProducto_PorID');
Route::get('ListarClientes', 'PedidoController@ListarClientes');

Route::post('GenerarPDF', 'PedidoController@GenerarPDF');
