<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>RESTAURANT</title>
    <link rel="icon" type="image/png" href="/files/img/icon/panadero.svg" />
    
    <meta http-equiv="Expires" content="0">
    <meta http-equiv="Last-Modified" content="0">
    <meta http-equiv="Cache-Control" content="no-cache, mustrevalidate">
    <meta http-equiv="Pragma" content="no-cache">
    
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <link rel="stylesheet" href="/files/plantilla/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="/files/plantilla/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="/files/librerias/sweetAlert/sweetalert.css" media="screen" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="/files/newJS/datatables/jquery.dataTables.min.css">
    <?php echo $__env->yieldContent('estilos'); ?>
</head>

<body class="sidebar-mini layout-fixed">
    <div class="wrapper">
        <nav class="main-header navbar navbar-expand navbar-dark bg-purple">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('Pedido.index')); ?>"><i class="fas fa-home"></i>
                        <abbr class="d-none d-sm-block float-right" style="text-decoration: none">&nbsp;Inicio</abbr>
                    </a>
                </li>
                <li class="nav-item d-block d-sm-none">
                    <a class="nav-link" href="<?php echo e(route('Caja.VerCaja')); ?>"><i class="fas fa-sign-out-alt"></i>
                        Caja: <?php echo e($user['CD_Codigo']); ?></a>
                </li>
                <li class="nav-item d-none d-sm-block">
                    <a class="nav-link" href="<?php echo e(route('Caja.VerCaja')); ?>"><i class="fas fa-funnel-dollar"></i>
                        Caja: <?php echo e($user['CD_Codigo']); ?>, <?php echo e($user['CD_Estado']); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('logout')); ?>"><i class="fas fa-sign-out-alt"></i>
                        Salir</a>
                </li>
            </ul>
        </nav>
        
        <aside class="main-sidebar sidebar-dark-primary elevation-4" style="background-color: #891e97 ">
            <div class="brand-link">
                <img alt="AdminLTE Logo" class="brand-image img-circle elevation-3" src="/files/img/cargo.png"
                    style="opacity: .8">
                <span
                    class="brand-text font-weight-light">Sistema JF</span>
            </div>

            <div class="sidebar">
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <a href="<?php echo e(asset('/files/img/foto-user/male.jpg')); ?>" data-rel="lightcase" title="<?php echo e($user['nombres'].' '.$user['apellidos']); ?>">
                            <img class="img-circle elevation-2" alt="Foto de Perfil"
                                src="<?php echo e(asset('/files/img/foto-user/male.jpg')); ?>">
                        </a>
                    </div>
                    <div class="info">
                        <label for="" style="color: white"><?php echo e($user['nombres']); ?> <i
                                class="fas fa-circle text-success"></i></label>
                    </div>
                </div>

                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">

                        <li class="nav-header">OPERACIONES</li>
                        <li class="nav-item has-treeview <?php if(session('pos')=='1' ): ?> menu-open <?php endif; ?>">
                            <a href="#" class="nav-link <?php if(session('pos')=='1' ): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-check-circle"></i>
                                <p>
                                    Comandas
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Pedido.index')); ?>" class="nav-link <?php if(session('subitem')=='1.1' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fas fa-border-all"></i>                                        
                                        <p>De Mesas</p>
                                    </a>
                                </li>
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Pedido.ParaLlevar')); ?>" class="nav-link <?php if(session('subitem')=='1.2' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fas fa-square"></i>                                        
                                        <p>Para Llevar</p>
                                    </a>
                                </li>
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Pedido.Delivery')); ?>" class="nav-link <?php if(session('subitem')=='1.3' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fas fa-shipping-fast"></i>                                        
                                        <p>Delivery</p>
                                    </a>
                                </li>
                            </ul>
                        </li>

                        <li class="nav-header">CONSULTAS</li>
                        <li class="nav-item has-treeview <?php if(session('pos')=='2' ): ?> menu-open <?php endif; ?>">
                            <a href="#" class="nav-link <?php if(session('pos')=='2' ): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-box"></i>
                                <p>
                                    Caja
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Caja.VerCaja')); ?>" class="nav-link <?php if(session('subitem')=='2.1' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fa fa-cash-register"></i>                                        
                                        <p>Ver Caja</p>
                                    </a>
                                </li> 
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Caja.VerIngresos')); ?>" class="nav-link <?php if(session('subitem')=='2.2' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fa fa-hand-holding-usd"></i>                                        
                                        <p>Ingresos</p>
                                    </a>
                                </li> 
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Caja.VerEgresos')); ?>" class="nav-link <?php if(session('subitem')=='2.3' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fas fa-calendar-times"></i>                                        
                                        <p>Egresos</p>
                                    </a>
                                </li>                                
                            </ul>
                        </li>
                        
                        <li class="nav-item has-treeview <?php if(session('pos')=='3' ): ?> menu-open <?php endif; ?>">
                            <a href="#" class="nav-link <?php if(session('pos')=='3' ): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-chart-line"></i>
                                <p>
                                    Ventas
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Ventas.VerVentas')); ?>" class="nav-link <?php if(session('subitem')=='3.1' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fa fa-dollar-sign"></i>                                        
                                        <p>Listar Ventas</p>
                                    </a>
                                </li> 
                            </ul>
                        </li>
                        
                        <li class="nav-item has-treeview <?php if(session('pos')=='4' ): ?> menu-open <?php endif; ?>">
                            <a href="#" class="nav-link <?php if(session('pos')=='4' ): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-truck"></i>
                                <p>
                                    Almacén
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Almacen.VerComidas')); ?>" class="nav-link <?php if(session('subitem')=='4.1' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fa fa-utensils"></i>                                        
                                        <p>Comidas</p>
                                    </a>
                                </li> 
                            </ul>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Almacen.VerBebidas')); ?>" class="nav-link <?php if(session('subitem')=='4.2' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fa fa-beer"></i>                                        
                                        <p>Bebidas</p>
                                    </a>
                                </li> 
                            </ul>
                            <ul class="nav nav-treeview">
                                <li class="nav-item">                                    
                                    <a href="<?php echo e(route('Almacen.VerInsumos')); ?>" class="nav-link <?php if(session('subitem')=='4.3' ): ?> active <?php endif; ?>">
                                        <i class="nav-icon fa fa-egg"></i>                                        
                                        <p>Insumos</p>
                                    </a>
                                </li> 
                            </ul>
                        </li>
                        
                        <li class="nav-item">
                            <a href="<?php echo e(route('Reportes.index')); ?>" class="nav-link <?php if(session('pos')=='5' ): ?> active <?php endif; ?>">
                                <i class="nav-icon fas fa-book"></i>
                                <p>Reportes</p>
                            </a>
                        </li>
                        
                        <li class="nav-header">CUENTA</li>
                        <li class="nav-item has-treeview">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-cog"></i>
                                <p>
                                    Configuración
                                    <i class="right fas fa-angle-left"></i>
                                </p>
                            </a>
                            <ul class="nav nav-treeview">                                
                                <li class="nav-item">
                                    <form action="<?php echo e(route('logout')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-block btn-outline-secondary btn-sm text-white">
                                            Cerrar Sesión
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </nav>
            </div>
        </aside>

        <div class="content-wrapper">
            <br>

            <section class="content">
                <?php echo $__env->yieldContent('contenido'); ?>
            </section>
        </div>

        <footer class="main-footer">

        </footer>

        <aside class="control-sidebar control-sidebar-dark">
        </aside>
    </div>

    <script src="/files/plantilla/plugins/jquery/jquery.min.js"></script>
    <script src="/files/plantilla/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="/files/plantilla/dist/js/adminlte.min.js"></script>

    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
    <script src="/files/newJS/ruta-api.js?v=<?php echo e(date('d-m-Y h:i:s')); ?>"></script>
    <script src="/files/newJS/datatables/jquery.dataTables.min.js"></script>
    <script src="/files/librerias/sweetAlert/sweetalert-dev.js?v=<?php echo e(date('d-m-Y h:i:s')); ?>"></script>
    <script src="/files/librerias/ui/jquery.blockUI.js"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>
<?php /**PATH /home/jftusolucion/SistemaDemonchis/resources/views/index.blade.php ENDPATH**/ ?>