$(document).ready(function (e) {
    $('#txtBuscar').keypress(function (e) {
        if (e.which == 13) {
            if ($('#txtBuscar').val().trim() == '')
                llenarTablaReservas('%20')
            else
                llenarTablaReservas($('#txtBuscar').val().trim())
        }
    })

    $('#modalBuscarReservas').on('shown.bs.modal', function (e) {
        $('#txtBuscar').focus()
    })
})

function BuscarReservas() {
    $('txtCliente').val('')
    $('#modalBuscarReservas').modal('show')
    llenarTablaReservas('%20')
}

function llenarTablaReservas(cliente) {
    $('#wainting').html('<i class="spinner-border spinner-border-sm mr-2 text-green"></i> Obteniendo reservas...')
    $.ajax({
        type: 'GET',
        url: RUTA_API + 'ListarReservasPendientes_PorCliente/' + cliente,
        dataType: 'JSON',
        success: function (data) {
            $('#wainting').html('')
            var tam = data.length;
            $('#bodyTablaReservas').html('')
            htmlTablaReserva(data)
        },
        error: function (error) {
            console.log(error)
        }
    })
}

function htmlTablaReserva(data) {
    data.forEach(element => {
        var fila = '<tr style="cursor: pointer"> ' +
            '<td>' + element.RES_FechaEmision + '</td> ' +
            '<td>' + element.RES_HoraEmision + '</td> ' +
            '<td style="background-color: yellow">MESA ' + element.MES_Numero + '</td> ' +
            '<td>' + element.MES_Ubicacion + '</td> ' +
            '<td style="background-color: yellow">' + element.RES_Cliente + '</td> ' +
            '<td>' + element.RES_Telefono + '</td> ' +
            '<td>' + element.RES_Observacion + '</td> ' +
            '</tr> '
        $('#tblReservas').append(fila)
    });
}
