<?php

namespace App\Services;

use Codedge\Fpdf\Fpdf\Fpdf;

date_default_timezone_set('America/Lima');


class PDF_Dash extends FPDF
{
    function SetDash($black = null, $white = null)
    {
        if ($black !== null)
            $s = sprintf('[%.3F %.3F] 0 d', $black * $this->k, $white * $this->k);
        else
            $s = '[] 0 d';
        $this->_out($s);
    }
}
class PDFService
{
    // Aquí puedes agregar métodos personalizados para generar PDFs
    public function createPDF()
    {
        $pdf = new PDF_Dash('P', 'mm');
        $pdf->AddPage('P', 'A4');
        $pdf->SetFont('Arial', 'B', 16);

        $fontSize = 10;
        $paddingGeneral = 10;

        $inicio = $paddingGeneral * 3.7;
        $fin = $pdf->GetPageWidth() * 0.47;

        $pdf->SetY($paddingGeneral);
        imprimirImagen($pdf, $inicio, $fin, "../app/Services/uriol-logo.png", 0);
        $y = $pdf->GetY();

        $pdf->SetY($paddingGeneral);
        $posicionA = [(($pdf->GetPageWidth() * 0.6) - ($paddingGeneral * 0.25)), $pdf->GetY()];
        $posicionB = [$pdf->GetPageWidth() - $paddingGeneral, $pdf->GetY()];
        $inicio = $pdf->GetPageWidth() * 0.6;
        $fin = $pdf->GetPageWidth() - $paddingGeneral * 1.25;
        $pdf->SetY($paddingGeneral * 1.25);
        imprimirTextoMultilinea($pdf, "RUC: 20559848167", "", $fontSize * 1.20, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "BOLETA ELECTRÓNICA", "", $fontSize * 1.20, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "B001-0000000087", "", $fontSize * 1.20, "C", 0, $inicio, $fin);

        saltarDeLinea($pdf, 2.5);

        $posicionC = [(($pdf->GetPageWidth() * 0.6) - ($paddingGeneral * 0.25)), $pdf->GetY()];
        $posicionD = [$pdf->GetPageWidth() - $paddingGeneral, $pdf->GetY()];
        imprimirRectangulo($pdf, 0, $posicionA, $posicionB, $posicionC, $posicionD);


        $pdf->SetY($y);
        saltarDeLinea($pdf, 5);


        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() * 0.6;
        $y = $pdf->GetY();

        imprimirTextoMultilinea($pdf, "VENTAS DE REPUESTOS AUTOMOTRIZ", "", $fontSize * 0.6, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "FAJA - RODAJES - AMORTIGUADORES - MUELLES", "", $fontSize * 0.6, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "REPARACIÓN COMPLETA PARA TODO TIPO DE VEHÍCULOS", "", $fontSize * 0.6, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "CONTACTO: 000 000 000", "B", $fontSize * 0.75, "C", 0, $inicio, $fin);
        imprimirTextoMultilinea($pdf, "CAL. CAJAMARCA NRO. 116 CENTRO CHEPEN - CHEPEN - LA LIBERTAD", "B", $fontSize * 0.75, "C", 0, $inicio, $fin);
        $y = $y - 5;
        $pdf->SetY($y + 1.5);
        $inicio = $pdf->GetPageWidth() * 0.66;
        $fin = $pdf->GetPageWidth() * 0.81;
        imprimirImagen($pdf, $inicio, $fin, "../app/Services/castrol.png", 0);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8325;
        $fin = $pdf->GetPageWidth() * 0.89;
        imprimirImagen($pdf, $inicio, $fin, "../app/Services/nisan.png", 0);

        $y = $pdf->GetY();
        $y = $y + 2.5;
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.69;
        $fin = $pdf->GetPageWidth() * 0.78;
        imprimirImagen($pdf, $inicio, $fin, "../app/Services/hiunday.png", 0);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.82;
        $fin = $pdf->GetPageWidth() * 0.9;
        imprimirImagen($pdf, $inicio, $fin, "../app/Services/jac.png", 0);



        saltarDeLinea($pdf, 5);
        $posicionA = [$paddingGeneral, $pdf->GetY()];
        $posicionB = [$pdf->GetPageWidth() - $paddingGeneral, $pdf->GetY()];

        saltarDeLinea($pdf, 5);
        $y = $pdf->GetY();
        $inicio = $paddingGeneral * 1.5;
        $fin = $pdf->GetPageWidth() * 0.18;
        imprimirTextoMultilinea($pdf, "FECHA", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.18;
        $fin = $pdf->GetPageWidth() * 0.2;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.2;
        $fin = $pdf->GetPageWidth() * 0.5;
        imprimirTextoMultilinea($pdf, "17 DE JUNIO DEL 2024", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.525;
        $fin = $pdf->GetPageWidth() * 0.64;
        imprimirTextoMultilinea($pdf, "CONDICION", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.64;
        $fin = $pdf->GetPageWidth() * 0.66;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.66;
        $fin = $pdf->GetPageWidth() - ($paddingGeneral * 1.5);
        imprimirTextoMultilinea($pdf, "CONTADO", "", $fontSize * 1, "L", 0, $inicio, $fin);



        $y = $pdf->GetY();
        $inicio = $paddingGeneral * 1.5;
        $fin = $pdf->GetPageWidth() * 0.18;
        imprimirTextoMultilinea($pdf, "R.U.C.", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.18;
        $fin = $pdf->GetPageWidth() * 0.2;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.2;
        $fin = $pdf->GetPageWidth() * 0.5;
        imprimirTextoMultilinea($pdf, "19247757", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.525;
        $fin = $pdf->GetPageWidth() * 0.64;
        imprimirTextoMultilinea($pdf, "F. VCTO", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.64;
        $fin = $pdf->GetPageWidth() * 0.66;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.66;
        $fin = $pdf->GetPageWidth() - ($paddingGeneral * 1.5);
        imprimirTextoMultilinea($pdf, "-", "", $fontSize * 1, "L", 0, $inicio, $fin);



        $y = $pdf->GetY();
        $inicio = $paddingGeneral * 1.5;
        $fin = $pdf->GetPageWidth() * 0.18;
        imprimirTextoMultilinea($pdf, "SEÑOR(ES)", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.18;
        $fin = $pdf->GetPageWidth() * 0.2;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.2;
        $fin = $pdf->GetPageWidth() * 0.5;
        imprimirTextoMultilinea($pdf, "MIRANDA LEZAMA SEGUNDO LUIS", "", $fontSize * 1, "L", 0, $inicio, $fin);



        $y = $pdf->GetY();
        $inicio = $paddingGeneral * 1.5;
        $fin = $pdf->GetPageWidth() * 0.18;
        imprimirTextoMultilinea($pdf, "DIRECCION", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.18;
        $fin = $pdf->GetPageWidth() * 0.2;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.2;
        $fin = $pdf->GetPageWidth() * 0.5;
        imprimirTextoMultilinea($pdf, "-", "", $fontSize * 1, "L", 0, $inicio, $fin);



        $y = $pdf->GetY();
        $inicio = $paddingGeneral * 1.5;
        $fin = $pdf->GetPageWidth() * 0.18;
        imprimirTextoMultilinea($pdf, "GLOSA", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.18;
        $fin = $pdf->GetPageWidth() * 0.2;
        imprimirTextoMultilinea($pdf, ":", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.2;
        $fin = $pdf->GetPageWidth() * 0.5;
        imprimirTextoMultilinea($pdf, "-", "", $fontSize * 1, "L", 0, $inicio, $fin);

        saltarDeLinea($pdf, 5);

        $posicionC = [$paddingGeneral, $pdf->GetY()];
        $posicionD = [$pdf->GetPageWidth() - $paddingGeneral, $pdf->GetY()];
        imprimirRectangulo($pdf, 0, $posicionA, $posicionB, $posicionC, $posicionD);

        saltarDeLinea($pdf, 5);


        $y = $pdf->GetY();
        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() * 0.15;
        imprimirTextoMultilinea($pdf, "CANT.", "B", $fontSize * 1, "C", 1, $inicio, $fin);

        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.15;
        $fin = $pdf->GetPageWidth() * 0.3;
        imprimirTextoMultilinea($pdf, "UNID.", "B", $fontSize * 1, "C", 1, $inicio, $fin);

        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.3;
        $fin = $pdf->GetPageWidth() * 0.65;
        imprimirTextoMultilinea($pdf, "DESCRIPCIÓN", "B", $fontSize * 1, "C", 1, $inicio, $fin);

        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.65;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "PRECIO (S/)", "B", $fontSize * 1, "C", 1, $inicio, $fin);

        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, "TOTAL (S/)", "B", $fontSize * 1, "C", 1, $inicio, $fin);



        $productos = array(
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            ),
            array(
                'cantidad' => 7,
                'unidad' => 'UND',
                'descripcion' => 'pollo asado cocina en 3/4 y con extra mayonesa ',
                'precio' => 20,
                'total' => 140
            ),
            array(
                'cantidad' => 5,
                'unidad' => 'UND',
                'descripcion' => 'arroz blanco',
                'precio' => 10,
                'total' => 50
            ),
            array(
                'cantidad' => 10,
                'unidad' => 'UND',
                'descripcion' => 'ensalada fresca',
                'precio' => 15,
                'total' => 150
            ),
            array(
                'cantidad' => 3,
                'unidad' => 'UND',
                'descripcion' => 'agua mineral',
                'precio' => 5,
                'total' => 15
            )
        );

        $posiciones_y = array();

        $sub_total = 0;

        // >>>>>>>>>> FILAS DE PRODUCTOS <<<<<<<<<<<
        for ($i = 0; $i < count($productos); ++$i) {
            $producto = $productos[$i];
            $y = ($i > 0 ? max($posiciones_y) : $pdf->GetY());
            $y += 1.25;

            if ($y > 260) {
                $pdf->AddPage();
                $y = $y - 260 + 10;
                $pdf->SetXY(0, $y);
                $posiciones_y = array();
            }

            //$y = $pdf->GetY();

            $pdf->SetXY(0, $y);
            $inicio = $paddingGeneral;
            $fin = $pdf->GetPageWidth() * 0.15;
            imprimirTextoMultilinea($pdf, $producto["cantidad"], "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $pdf->SetXY(0, $y);
            $inicio = $pdf->GetPageWidth() * 0.15;
            $fin = $pdf->GetPageWidth() * 0.3;
            imprimirTextoMultilinea($pdf, $producto["unidad"], "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $pdf->SetXY(0, $y);
            $inicio = $pdf->GetPageWidth() * 0.3;
            $fin = $pdf->GetPageWidth() * 0.65;
            imprimirTextoMultilinea($pdf, $producto["descripcion"], "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $pdf->SetXY(0, $y);
            $inicio = $pdf->GetPageWidth() * 0.65;
            $fin = $pdf->GetPageWidth() * 0.8;
            imprimirTextoMultilinea($pdf, number_format($producto["precio"] * 1, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $pdf->SetXY(0, $y);
            $inicio = $pdf->GetPageWidth() * 0.8;
            $fin = $pdf->GetPageWidth() - $paddingGeneral;
            imprimirTextoMultilinea($pdf, number_format($producto["total"] * 1, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);
            array_push($posiciones_y, $pdf->GetY());

            $sub_total += $producto["cantidad"] * $producto["precio"];
        }


        saltarDeLinea($pdf, 4);
        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirLineaHorizontal($pdf, $inicio, $fin);
        saltarDeLinea($pdf, 4);


        $y = $pdf->getY();


        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() * 0.25;
        imprimirTextoMultilinea($pdf, "LEYENDA", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        saltarDeLinea($pdf, 0);
        $inicio = $paddingGeneral;
        $fin = $pdf->GetPageWidth() * 0.50;
        imprimirTextoMultilinea($pdf, "QUINIENTOS SETENTA Y TRES 00/100 SOLES", "", $fontSize * 1, "L", 0, $inicio, $fin);


        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "OP: GRAVADAS:                   S/", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format($sub_total / 1.18, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);



        $y = $pdf->getY();
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "OP: EXONERADAS:              S/", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format(0, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);


        $y = $pdf->getY();
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "OP: INAFECTAS:                   S/", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format(0, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);


        $y = $pdf->getY();
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "IGV:                                        S/", "", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format($sub_total * 0.18, 2), "", $fontSize * 1, "C", 0, $inicio, $fin);


        saltarDeLinea($pdf, 4);
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirLineaHorizontal($pdf, $inicio, $fin);
        saltarDeLinea($pdf, 4);
        //$pdf->SetY($y);


        $y = $pdf->getY();
        $inicio = $pdf->GetPageWidth() * 0.55;
        $fin = $pdf->GetPageWidth() * 0.8;
        imprimirTextoMultilinea($pdf, "IMPORTE TOTAL:                 S/", "B", $fontSize * 1, "L", 0, $inicio, $fin);
        $pdf->SetY($y);
        $inicio = $pdf->GetPageWidth() * 0.8;
        $fin = $pdf->GetPageWidth() - $paddingGeneral;
        imprimirTextoMultilinea($pdf, number_format($sub_total, 2), "B", $fontSize * 1, "C", 0, $inicio, $fin);


        // $this->Output('F', 'archivo.pdf'); // El segundo parámetro 'D' indica que se descargará el archivo
        $pdf->Output();
    }
}

function imp($text)
{
    $text = iconv('UTF-8', 'windows-1252', $text);
    return $text;
}

function centrarTexto($pdf, $text, $lineHeight, $b, $font_size)
{
    $ancho_del_ticket = $pdf->GetPageWidth(1);
    $pdf->SetFont('helvetica', $b, $font_size);
    $pdf->SetX(0);
    $pdf->MultiCell($ancho_del_ticket, $lineHeight, imp($text), 0, 'C', '');
}

function imprimirTextoMultilinea($pdf, $text, $b, $fontSize, $textAlign, $border, $start, $end)
{
    // Calcular la altura de línea basada en el tamaño de fuente
    $lineHeight = $fontSize * 0.5; // Por ejemplo, 1.5 veces el tamaño de fuente

    $pdf->SetFont('helvetica', $b, $fontSize);
    $pdf->SetX($start);
    $pdf->MultiCell($end - $start, $lineHeight, strtoupper(imp($text)), $border, $textAlign, '');
}

function imprimirImagen($pdf, $start, $end, $ruta_imagen, $padding)
{
    // Obtener la información de la imagen original
    list($originalWidth, $originalHeight) = getimagesize($ruta_imagen);

    // Calcular el ancho en función de la altura y la relación de aspecto
    $aspectRatio = $originalWidth / $originalHeight;
    $alto_de_la_imagen = ($end - $start) / $aspectRatio;

    // Obtener la posición actual de Y
    $y = $pdf->GetY();

    // Ajustar las coordenadas y dimensiones con el padding
    $x = $start + $padding;
    $y += $padding;
    $ancho = $end - $start - 2 * $padding;
    $alto = $alto_de_la_imagen - 2 * $padding;

    // Insertar la imagen en la página
    $pdf->Image($ruta_imagen, $x, $y, $ancho, $alto);

    // Calcular el siguiente valor de Y sumando el alto de la imagen y el padding
    $siguiente_y = $y + $alto + $padding;

    // Ajustar la posición Y para el siguiente elemento
    $pdf->SetY($siguiente_y);
}

function saltarDeLinea($pdf, $numeroDeSaltos)
{
    $y_actual = $pdf->GetY();
    $pdf->Ln($numeroDeSaltos);
    $pdf->SetY($y_actual + $numeroDeSaltos);
}

function imprimirLineaHorizontal($pdf, $inicioX, $finX, $alturaY = null)
{
    // Si no se proporciona la altura Y, se establece un valor predeterminado
    if ($alturaY === null) {
        $alturaY = $pdf->GetY();
    }

    $pdf->SetLineWidth(0);
    $pdf->SetDash(0, 0);
    $pdf->SetFont('helvetica', '', 5);
    $pdf->Line($inicioX, $alturaY, $finX, $alturaY);
}


function imprimirRectangulo($pdf, $espacioEntreLineas, $posicionA, $posicionB, $posicionC, $posicionD)
{
    // $pdf->SetLineWidth(0.1);
    $pdf->SetDash($espacioEntreLineas, $espacioEntreLineas);
    // LINEA HORIZONTAL SUPERIOR
    $pdf->Line($posicionA[0], $posicionA[1], $posicionB[0], $posicionB[1]);

    // LINEA VERTICAL A LA IZQUIERDA
    $pdf->Line($posicionA[0], $posicionA[1], $posicionC[0], $posicionC[1]);

    // LINEA HORIZONTAL INFERIOR
    $pdf->Line($posicionC[0], $posicionC[1], $posicionD[0], $posicionD[1]);

    // LINEA VERTICAL A LA DERECHA
    $pdf->Line($posicionB[0], $posicionB[1], $posicionD[0], $posicionD[1]);
}
